/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.portlet.action;

import java.util.ArrayList;
import java.util.List;
import lime.NamespacePath;
import lime.outcome.Redirect;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.portlet.HomepageSettings;
import ua.com.softway.tracker.portlet.PortletName;
import ua.com.softway.tracker.portlet.action.ConfigurablePortlet;
import ua.com.softway.tracker.ui.SelectOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class HomepageSettingsAction {
    public PortletName portletName;
    public String direction = "";

    public List<ConfigurablePortlet> getPortlets() {
        ArrayList<ConfigurablePortlet> portlets = new ArrayList<ConfigurablePortlet>();
        HomepageSettings settings = User.currentUser().getHomepageSettings();
        for (PortletName portletName : settings.getPortletNames()) {
            portlets.add(new ConfigurablePortlet(portletName, settings));
        }
        return portlets;
    }

    public String configure() {
        return "homepageSettings";
    }

    public List<SelectOption> getPortletOptions() {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        HomepageSettings settings = User.currentUser().getHomepageSettings();
        for (PortletName portletName : PortletName.values()) {
            if (settings.getPortletNames().contains((Object)portletName)) continue;
            options.add(new SelectOption(portletName.name(), portletName.localizedName()));
        }
        return options;
    }

    public Redirect deletePortlet() {
        if (this.portletName != null) {
            HomepageSettings settings = User.currentUser().getHomepageSettings();
            settings.deletePortlet(this.portletName);
            User.currentUser().store();
        }
        return Pages.configureHomepage();
    }

    public Redirect addPortlet() {
        HomepageSettings settings = User.currentUser().getHomepageSettings();
        if (this.portletName != null && !settings.getPortletNames().contains((Object)this.portletName)) {
            settings.addPortlet(this.portletName);
            User.currentUser().store();
        }
        return Pages.configureHomepage();
    }

    public Redirect movePortlet() {
        HomepageSettings settings = User.currentUser().getHomepageSettings();
        if (this.portletName != null) {
            int position = settings.getPortletNames().indexOf((Object)this.portletName);
            if (this.direction.equals("up") && position > 0) {
                --position;
            }
            if (this.direction.equals("top")) {
                position = 0;
            }
            if (this.direction.equals("down") && position < settings.getPortletNames().size() - 1) {
                ++position;
            }
            if (this.direction.equals("bottom")) {
                position = settings.getPortletNames().size() - 1;
            }
            settings.movePortlet(this.portletName, position);
            User.currentUser().store();
        }
        return Pages.configureHomepage();
    }
}

