/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.permissions.action;

import java.util.ArrayList;
import java.util.List;
import lime.NamespacePath;
import lime.outcome.Redirect;
import ua.com.softway.tracker.Group;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.permissions.PermissionManager;
import ua.com.softway.tracker.permissions.action.PermissionTypeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker/admin")
public class ProjectPermissionsAction {
    private final Tracker tracker;
    public String projectKey;
    public String type;
    public String[] users;
    public String[] groups;

    public ProjectPermissionsAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public String display() {
        return "manage/projectPermissions";
    }

    public Project getProject() {
        return this.tracker.getProject(this.projectKey);
    }

    public List<PermissionTypeView> getTypes() {
        ArrayList<PermissionTypeView> types = new ArrayList<PermissionTypeView>();
        for (PermissionManager.PermissionType type : PermissionManager.PermissionType.values()) {
            types.add(new PermissionTypeView(type, this.getProject().getPermissionManager(), this.tracker, this.projectKey));
        }
        return types;
    }

    public Redirect add() {
        int i;
        PermissionManager permissions = this.getProject().getPermissionManager();
        PermissionManager.PermissionType t = PermissionManager.PermissionType.valueOf(this.type);
        if (this.users != null) {
            for (i = 0; i < this.users.length; ++i) {
                User user = this.tracker.getUser(this.users[i]);
                if (user == null) continue;
                permissions.allow(t, user);
            }
        }
        if (this.groups != null) {
            for (i = 0; i < this.groups.length; ++i) {
                Group group = this.tracker.getGroup(this.groups[i]);
                if (group == null) continue;
                permissions.allow(t, group);
            }
        }
        permissions.store();
        return Pages.projectPermissions(this.projectKey);
    }

    public Redirect remove() {
        int i;
        PermissionManager permissions = this.getProject().getPermissionManager();
        PermissionManager.PermissionType t = PermissionManager.PermissionType.valueOf(this.type);
        if (this.users != null) {
            for (i = 0; i < this.users.length; ++i) {
                User user = this.tracker.getUser(this.users[i]);
                if (user == null) continue;
                permissions.disallow(t, user);
            }
        }
        if (this.groups != null) {
            for (i = 0; i < this.groups.length; ++i) {
                Group group = this.tracker.getGroup(this.groups[i]);
                if (group == null) continue;
                permissions.disallow(t, group);
            }
        }
        permissions.store();
        return Pages.projectPermissions(this.projectKey);
    }
}

