/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.permissions.action;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Group;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.SelectOptions;
import ua.com.softway.tracker.i18n.Resources;
import ua.com.softway.tracker.permissions.PermissionManager;
import ua.com.softway.tracker.permissions.action.AllowedView;
import ua.com.softway.tracker.ui.SelectOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionTypeView {
    private final PermissionManager permissions;
    private final PermissionManager.PermissionType type;
    private final Tracker tracker;
    private final String projectKey;

    public PermissionTypeView(PermissionManager.PermissionType type, PermissionManager permissions, Tracker tracker, String projectKey) {
        this.type = type;
        this.permissions = permissions;
        this.tracker = tracker;
        this.projectKey = projectKey;
    }

    public String getName() {
        return Resources.getText("permission.type." + this.type.name().toLowerCase());
    }

    public String getKey() {
        return this.type.name();
    }

    public String getHelp() {
        return Resources.getText("permission.type.help." + this.type.name().toLowerCase());
    }

    public List<AllowedView> getAllowed() {
        ArrayList<AllowedView> result = new ArrayList<AllowedView>();
        for (Group group : this.permissions.getAllowedGroups(this.type)) {
            result.add(new AllowedView(this.projectKey, this.type, group));
        }
        for (User user : this.permissions.getAllowedUsers(this.type)) {
            result.add(new AllowedView(this.projectKey, this.type, user));
        }
        return result;
    }

    public List<SelectOption> getNewUsers() {
        List<User> users = this.tracker.getUsers();
        users.removeAll(this.permissions.getAllowedUsers(this.type));
        return SelectOptions.user(users, true);
    }

    public List<SelectOption> getNewGroups() {
        List<Group> groups = this.tracker.getGroups();
        groups.removeAll(this.permissions.getAllowedGroups(this.type));
        return SelectOptions.groups(groups, true);
    }
}

