/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.permissions;

import java.util.List;
import java.util.Map;
import ua.com.softway.tracker.Group;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.permissions.PermissionManager;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.storage.Properties;
import ua.com.softway.tracker.storage.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionManagerSerializer
implements Serializer<PermissionManager> {
    private final Tracker tracker;

    public PermissionManagerSerializer(Tracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public PermissionManager load(ObjectUpdater<PermissionManager> updater, Properties properties, String key) {
        PermissionManager permissions = new PermissionManager(updater);
        List<Properties> types = properties.getList("types");
        for (Properties typeProperties : types) {
            PermissionManager.PermissionType type = PermissionManager.PermissionType.valueOf(typeProperties.getProperty("key"));
            List<Properties> users = typeProperties.getList("users");
            List<Properties> groups = typeProperties.getList("groups");
            for (Properties userProperties : users) {
                String name = userProperties.getProperty("name");
                User user = this.tracker.getUser(name);
                if (user == null) continue;
                permissions.allow(type, user);
            }
            for (Properties groupProperties : groups) {
                String groupKey = groupProperties.getProperty("key");
                Group group = this.tracker.getGroup(groupKey);
                if (group == null) continue;
                permissions.allow(type, group);
            }
        }
        return permissions;
    }

    @Override
    public void save(Properties properties, PermissionManager object) {
        Map<PermissionManager.PermissionType, List> permissionMap = object.getPermissionMap();
        List<Properties> types = properties.addList("types", "type");
        for (PermissionManager.PermissionType type : permissionMap.keySet()) {
            Properties typeProperties = new Properties();
            types.add(typeProperties);
            typeProperties.addProperty("key", type.name());
            List<Properties> users = typeProperties.addList("users", "user");
            List<Properties> groups = typeProperties.addList("groups", "group");
            List usersAndGroups = permissionMap.get((Object)type);
            for (Object o : usersAndGroups) {
                Properties p = new Properties();
                if (o instanceof User) {
                    User user = (User)o;
                    p.addProperty("name", user.getLogin());
                    users.add(p);
                    continue;
                }
                Group group = (Group)o;
                p.addProperty("key", group.getKey());
                groups.add(p);
            }
        }
    }

    @Override
    public String getKey(PermissionManager object) {
        return "permissons";
    }
}

