/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.permissions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ua.com.softway.tracker.Group;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.permissions.PermissionChangeListener;
import ua.com.softway.tracker.permissions.ProjectPermissions;
import ua.com.softway.tracker.storage.ObjectUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionManager
implements ProjectPermissions {
    private final Map<PermissionType, List> permissionMap = new HashMap<PermissionType, List>();
    private final ObjectUpdater<PermissionManager> updater;
    private PermissionChangeListener listener;

    public PermissionManager(ObjectUpdater<PermissionManager> updater) {
        this.updater = updater;
        for (PermissionType type : PermissionType.values()) {
            this.permissionMap.put(type, new ArrayList());
        }
    }

    Map<PermissionType, List> getPermissionMap() {
        return this.permissionMap;
    }

    public List<User> getAllowedUsers(PermissionType type) {
        ArrayList<User> result = new ArrayList<User>();
        for (Object object : this.permissionMap.get((Object)type)) {
            if (!(object instanceof User)) continue;
            result.add((User)object);
        }
        Collections.sort(result);
        return result;
    }

    public List<Group> getAllowedGroups(PermissionType type) {
        ArrayList<Group> result = new ArrayList<Group>();
        for (Object object : this.permissionMap.get((Object)type)) {
            if (!(object instanceof Group)) continue;
            result.add((Group)object);
        }
        Collections.sort(result);
        return result;
    }

    public void allow(PermissionType type, User user) {
        for (Object object : this.permissionMap.get((Object)type)) {
            if (!(object instanceof User) || !user.equals(object)) continue;
            return;
        }
        this.permissionMap.get((Object)type).add(user);
        if (this.listener != null) {
            this.listener.permissionChanged(type, user, true);
        }
    }

    public void allow(PermissionType type, Group group) {
        for (Object object : this.permissionMap.get((Object)type)) {
            if (!(object instanceof Group) || !group.equals(object)) continue;
            return;
        }
        this.permissionMap.get((Object)type).add(group);
        if (this.listener != null) {
            this.listener.permissionChanged(type, group, true);
        }
    }

    public void disallow(PermissionType type, Group group) {
        Iterator i = this.permissionMap.get((Object)type).iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof Group) || !group.equals(obj)) continue;
            i.remove();
        }
        if (this.listener != null) {
            this.listener.permissionChanged(type, group, false);
        }
    }

    public void disallow(PermissionType type, User user) {
        Iterator i = this.permissionMap.get((Object)type).iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof User) || !user.equals(obj)) continue;
            i.remove();
        }
        if (this.listener != null) {
            this.listener.permissionChanged(type, user, false);
        }
    }

    public void store() {
        this.updater.saveOrUpdate(this);
    }

    @Override
    public List<User> getAssignees() {
        ArrayList<User> result = new ArrayList<User>();
        for (Object object : this.permissionMap.get((Object)PermissionType.Assignable)) {
            if (object instanceof Group) {
                Group group = (Group)object;
                result.addAll(group.getUsers());
                continue;
            }
            User user = (User)object;
            result.add(user);
        }
        Collections.sort(result);
        return result;
    }

    private boolean hasPermissionType(PermissionType permissionType) {
        for (Object object : this.permissionMap.get((Object)permissionType)) {
            User user;
            Group group;
            if (!(object instanceof Group ? (group = (Group)object).containsUser(User.currentUser()) : (user = (User)object).equals(User.currentUser()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canCreateIssue() {
        return this.hasPermissionType(PermissionType.CreateIssue);
    }

    @Override
    public boolean isProjectVisible() {
        return this.hasPermissionType(PermissionType.Browse);
    }

    @Override
    public boolean canEditIssue() {
        return this.hasPermissionType(PermissionType.EditIssue);
    }

    @Override
    public boolean canDeleteIssue() {
        return this.hasPermissionType(PermissionType.DeleteIssue);
    }

    @Override
    public boolean canCloseIssue() {
        return this.hasPermissionType(PermissionType.CloseIssue);
    }

    @Override
    public boolean canManageVersions() {
        return this.hasPermissionType(PermissionType.ManageVersions);
    }

    @Override
    public boolean canAssignIssue() {
        return this.hasPermissionType(PermissionType.Assign);
    }

    public PermissionChangeListener getListener() {
        return this.listener;
    }

    public void setListener(PermissionChangeListener listener) {
        this.listener = listener;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PermissionType {
        CreateIssue,
        Assignable,
        Browse,
        EditIssue,
        Assign,
        CloseIssue,
        DeleteIssue,
        ManageVersions;

    }
}

