/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.license;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class StreamObfuscator {
    private static final int OBFUSCATING_RATE = 10;
    private static final long SEED = 123454321L;

    public static OutputStream obfuscate(OutputStream outputStream) {
        return new ObfuscatedOutputStream(outputStream);
    }

    public static InputStream unobfuscate(InputStream inputStream) {
        return new UnobfescatedInputStream(inputStream);
    }

    private static class UnobfescatedInputStream
    extends FilterInputStream {
        private Random random = new Random(123454321L);

        public UnobfescatedInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            int b = this.in.read();
            if (b == -1) {
                return -1;
            }
            b = (byte)(b ^ this.random.nextInt());
            for (int i = 0; i < 10; ++i) {
                this.in.read();
                this.random.nextInt();
            }
            return b;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                int c = this.read();
                if (c == -1) {
                    if (i == 0) {
                        return -1;
                    }
                    return i;
                }
                b[off + i] = (byte)c;
            }
            return len;
        }
    }

    private static class ObfuscatedOutputStream
    extends FilterOutputStream {
        private Random random = new Random(123454321L);

        public ObfuscatedOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            this.out.write((byte)(b ^ this.random.nextInt()));
            for (int i = 0; i < 10; ++i) {
                this.out.write((byte)this.random.nextInt());
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.write(b[off + i]);
            }
        }
    }
}

