/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.license;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ua.com.softway.tracker.license.InvalidKeyException;
import ua.com.softway.tracker.license.KeyType;
import ua.com.softway.tracker.license.LicenseKey;
import ua.com.softway.tracker.license.StreamObfuscator;
import ua.com.softway.tracker.util.Base64;

public class LicenseKeySerializer {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");

    public static LicenseKey fromString(String s) throws InvalidKeyException {
        StringBuffer buffer = new StringBuffer();
        for (char ch : s.toCharArray()) {
            if (ch == ' ' || ch == '\r' || ch == '\n') continue;
            buffer.append(ch);
        }
        try {
            InputStream inputStream = new ByteArrayInputStream(Base64.decode(buffer.toString().toCharArray()));
            inputStream = StreamObfuscator.unobfuscate(inputStream);
            DataInputStream source = new DataInputStream(inputStream);
            String company = source.readUTF();
            Date start = dateFormat.parse(source.readUTF());
            Date end = dateFormat.parse(source.readUTF());
            int usersCount = Integer.parseInt(source.readUTF());
            KeyType keyType = null;
            try {
                keyType = KeyType.valueOf(source.readUTF());
            }
            catch (IllegalArgumentException e) {
                new InvalidKeyException(e);
            }
            source.close();
            return new LicenseKey(company, start, end, usersCount, keyType);
        }
        catch (FileNotFoundException e) {
            throw new InvalidKeyException(e);
        }
        catch (IOException e) {
            throw new InvalidKeyException(e);
        }
        catch (ParseException e) {
            throw new InvalidKeyException(e);
        }
        catch (NumberFormatException e) {
            throw new InvalidKeyException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidKeyException(e);
        }
    }

    public static String toString(LicenseKey key) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            OutputStream outputStream = StreamObfuscator.obfuscate(buffer);
            DataOutputStream target = new DataOutputStream(outputStream);
            target.writeUTF(key.getCompany());
            target.writeUTF(dateFormat.format(key.getStart()));
            target.writeUTF(dateFormat.format(key.getEnd()));
            target.writeUTF("" + key.getUsersCount());
            target.writeUTF(key.getType().name());
            target.close();
            return new String(Base64.encode(buffer.toByteArray()));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

