/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.license;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ua.com.softway.tracker.license.KeyType;

public class LicenseKey {
    public static final Date UNLIMITED_END_DATE;
    public static final int UNLIMITED_USERS_COUNT = 1000000;
    private String company;
    private Date start;
    private Date end;
    private int usersCount;
    private KeyType type;

    public LicenseKey(String company, Date start, Date end, int usersCount, KeyType type) {
        this.company = company;
        this.start = start;
        this.end = end;
        this.usersCount = usersCount;
        this.type = type;
    }

    public String getCompany() {
        return this.company;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean isEndLimited() {
        return !UNLIMITED_END_DATE.equals(this.end);
    }

    public boolean isExpired() {
        return this.getEnd().compareTo(new Date()) < 0;
    }

    public int getUsersCount() {
        return this.usersCount;
    }

    public boolean isUsersCountLimited() {
        return this.usersCount != 1000000;
    }

    public KeyType getType() {
        return this.type;
    }

    static {
        try {
            UNLIMITED_END_DATE = new SimpleDateFormat("dd.MM.yyyy").parse("01.01.3000");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

