/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.issuebrowser.action;

import java.util.ArrayList;
import java.util.List;
import lime.NamespacePath;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.issuebrowser.IssueBrowserConfiguration;
import ua.com.softway.tracker.issuebrowser.action.ConfigurableColumn;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.ui.SelectOption;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class IssueBrowserConfigurationAction {
    public IssueField column;
    public String direction = "";
    public Messages messages = new Messages();

    public String editConfiguration() {
        return "issueBrowserConfiguration";
    }

    public List<SelectOption> getColumnOptions() {
        ArrayList<SelectOption> result = new ArrayList<SelectOption>();
        IssueBrowserConfiguration browserConfiguration = User.currentUser().getIssueBrowserConfiguration();
        for (IssueField issueField : IssueField.values()) {
            if (browserConfiguration.getFields().contains(issueField)) continue;
            result.add(new SelectOption(issueField.name(), Strings.capitalize(issueField.localizedName())));
        }
        return result;
    }

    public List<ConfigurableColumn> getColumns() {
        ArrayList<ConfigurableColumn> columns = new ArrayList<ConfigurableColumn>();
        List<IssueField> issueFields = User.currentUser().getIssueBrowserConfiguration().getFields();
        for (IssueField issueField : issueFields) {
            columns.add(new ConfigurableColumn(issueField, issueFields));
        }
        return columns;
    }

    public Object moveColumn() {
        IssueBrowserConfiguration browserConfiguration = User.currentUser().getIssueBrowserConfiguration();
        int position = browserConfiguration.getFields().indexOf(this.column);
        if (position != -1) {
            if ("left".equals(this.direction) && position > 0) {
                --position;
            }
            if ("right".equals(this.direction) && position < browserConfiguration.getFields().size() - 1) {
                ++position;
            }
            browserConfiguration.moveField(this.column, position);
            User.currentUser().store();
        }
        return Pages.editIssueBrowserConfiguration();
    }

    public Object addColumn() {
        IssueBrowserConfiguration browserConfiguration = User.currentUser().getIssueBrowserConfiguration();
        if (browserConfiguration.getFields().contains(this.column)) {
            return Pages.editIssueBrowserConfiguration();
        }
        if (this.column == null) {
            this.messages.addMessage("issueBrowser.column.not.found", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return this.editConfiguration();
        }
        browserConfiguration.addField(this.column);
        User.currentUser().store();
        return Pages.editIssueBrowserConfiguration();
    }

    public Object deleteColumn() {
        IssueBrowserConfiguration browserConfiguration = User.currentUser().getIssueBrowserConfiguration();
        if (browserConfiguration.getFields().contains(this.column)) {
            browserConfiguration.deleteField(this.column);
            User.currentUser().store();
        }
        return Pages.editIssueBrowserConfiguration();
    }
}

