/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.issuebrowser.action;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueBrowser {
    private List<IssueField> fields;
    private List<Issue> issues;

    public IssueBrowser(List<Issue> issues, List<IssueField> fields) {
        this.issues = issues;
        this.fields = fields;
    }

    public List<BrowserHeader> getHeaders() {
        ArrayList<BrowserHeader> headers = new ArrayList<BrowserHeader>();
        for (IssueField issueField : this.fields) {
            headers.add(new BrowserHeader(issueField));
        }
        return headers;
    }

    public List<BrowserRow> getRows() {
        ArrayList<BrowserRow> rows = new ArrayList<BrowserRow>();
        for (Issue issue : this.issues) {
            rows.add(new BrowserRow(issue, this.fields));
        }
        return rows;
    }

    public static class BrowserHeader {
        private IssueField issueField;

        public BrowserHeader(IssueField issueField) {
            this.issueField = issueField;
        }

        public IssueField getIssueField() {
            return this.issueField;
        }

        public String getName() {
            return Strings.capitalize(this.issueField.localizedName());
        }

        public boolean isWide() {
            return this.issueField.equals(IssueField.SUMMARY);
        }
    }

    public static class BrowserColumn {
        private IssueField issueField;
        private Issue issue;

        public BrowserColumn(Issue issue, IssueField issueField) {
            this.issueField = issueField;
            this.issue = issue;
        }

        public String getHtml() {
            return this.issueField.getHtmlValue(this.issue);
        }

        public String getText() {
            return this.issueField.getValue(this.issue);
        }

        public IssueField getIssueField() {
            return this.issueField;
        }

        public boolean isWide() {
            return this.issueField.equals(IssueField.SUMMARY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrowserRow {
        private Issue issue;
        private List<IssueField> fields;

        public BrowserRow(Issue issue, List<IssueField> fields) {
            this.issue = issue;
            this.fields = fields;
        }

        public List<BrowserColumn> getColumns() {
            ArrayList<BrowserColumn> columns = new ArrayList<BrowserColumn>();
            for (IssueField issueField : this.fields) {
                columns.add(new BrowserColumn(this.issue, issueField));
            }
            return columns;
        }
    }
}

