/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.issuebrowser;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.IssueField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueBrowserConfiguration {
    private List<IssueField> issueFields = new ArrayList<IssueField>();

    public List<IssueField> getFields() {
        return new ArrayList<IssueField>(this.issueFields);
    }

    public void addField(IssueField issueField) {
        this.issueFields.add(issueField);
    }

    public void moveField(IssueField issueField, int position) {
        if (!this.issueFields.contains(issueField)) {
            throw new IllegalArgumentException(issueField + " is not in collection");
        }
        if (issueField == null) {
            throw new IllegalArgumentException("issueField is null");
        }
        if (position < 0 || position >= this.issueFields.size()) {
            throw new IllegalArgumentException("invalid position " + position);
        }
        this.issueFields.remove(issueField);
        this.issueFields.add(position, issueField);
    }

    public void deleteField(IssueField issueField) {
        if (!this.issueFields.contains(issueField)) {
            throw new IllegalArgumentException(issueField + " is not in collection");
        }
        this.issueFields.remove(issueField);
    }

    public void resetToDefault() {
        this.addField(IssueField.KEY);
        this.addField(IssueField.TYPE);
        this.addField(IssueField.STATUS);
        this.addField(IssueField.SUMMARY);
        this.addField(IssueField.REPORTER);
        this.addField(IssueField.ASSIGNEE);
    }
}

