/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import ua.com.softway.tracker.i18n.Bundle;
import ua.com.softway.tracker.i18n.Bundles;
import ua.com.softway.tracker.i18n.ResourceLocation;

public class Resources {
    static ThreadLocal<String> currentLocale = new ThreadLocal();
    static Map<String, Bundles> localeBundles = new HashMap<String, Bundles>();

    public static void addBundle(ResourceLocation location) {
        int begin = location.getName().lastIndexOf(95);
        if (begin == -1) {
            throw new IllegalArgumentException("Resource name must ends with '_<lang>.properties' and it is '" + location + "'");
        }
        int end = location.getName().indexOf(46, begin);
        if (end == -1) {
            throw new IllegalArgumentException("Resource name must ends with '_<lang>.properties' and it is '" + location + "'");
        }
        String locale = location.getName().substring(begin + 1, end);
        Bundles bundles = localeBundles.get(locale);
        if (bundles == null) {
            bundles = new Bundles();
            localeBundles.put(locale, bundles);
        }
        Bundle bundle = new Bundle(location);
        bundles.addBundle(bundle);
    }

    public static String getText(String key) {
        if (currentLocale.get() == null) {
            throw new IllegalStateException("No locale set");
        }
        Bundles bundles = localeBundles.get(currentLocale.get());
        if (bundles == null) {
            return key;
        }
        String value = bundles.getProperty(key);
        if (value == null) {
            return key;
        }
        return value;
    }

    public static String getText(String key, Object ... args) {
        String pattern = Resources.getText(key);
        if (pattern == null) {
            return null;
        }
        return MessageFormat.format(pattern, args);
    }

    public static void setLocale(String locale) {
        currentLocale.set(locale);
    }
}

