/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.i18n;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.fs.nativefs.NativeFileSystem;
import ua.com.softway.tracker.i18n.ClasspathResourceLocation;
import ua.com.softway.tracker.i18n.FileResourceLocation;
import ua.com.softway.tracker.i18n.ResourceListener;
import ua.com.softway.tracker.i18n.ServletContextResourceLocation;
import ua.com.softway.tracker.util.Classpath;

public class ResourceScanner {
    private final ResourceListener listener;

    public ResourceScanner(ResourceListener listener) {
        this.listener = listener;
    }

    public boolean findInFileSystem(Folder root) {
        if (!root.exists()) {
            return false;
        }
        for (ua.com.softway.tracker.fs.File file : root.getFiles()) {
            this.listener.bundleFound(new FileResourceLocation(file));
        }
        for (Folder folder : root.getFolders()) {
            this.findInFileSystem(folder);
        }
        return true;
    }

    public boolean findInClasspath() {
        String jarPath = Classpath.getClarityJarPath();
        if (jarPath == null) {
            return false;
        }
        try {
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                this.listener.bundleFound(new ClasspathResourceLocation(entry.getName()));
            }
            jarFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean findInExplodedWar(ServletContext context) {
        String webPath = context.getRealPath("/");
        if (webPath == null) {
            return false;
        }
        return this.findInFileSystem(NativeFileSystem.fromFolder(new File(webPath)));
    }

    public boolean findInTomcatWar(ServletContext servletContext) {
        try {
            Field contextField = servletContext.getClass().getDeclaredField("context");
            contextField.setAccessible(true);
            Object context = contextField.get(servletContext);
            Field basePathField = context.getClass().getDeclaredField("basePath");
            basePathField.setAccessible(true);
            String basePath = (String)basePathField.get(context);
            if (basePath == null) {
                return false;
            }
            if (!basePath.endsWith(".war")) {
                return false;
            }
            try {
                JarFile jarFile = new JarFile(basePath);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    this.listener.bundleFound(new ServletContextResourceLocation(servletContext, entry.getName()));
                }
                jarFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        return true;
    }
}

