/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.i18n;

import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import ua.com.softway.tracker.i18n.ResourceLocation;

public class ClasspathResourceLocation
implements ResourceLocation {
    private final String name;

    public ClasspathResourceLocation(String name) {
        this.name = name;
    }

    public InputStream getInputStream() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream resourceStream = loader.getResourceAsStream(this.name);
        return resourceStream;
    }

    public String getName() {
        return this.name;
    }

    public long lastModified() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resource = loader.getResource(this.name);
        if (resource == null) {
            return 0L;
        }
        if ("file".equals(resource.getProtocol())) {
            try {
                File file = new File(resource.toURI());
                return file.lastModified();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return 0L;
    }

    public String toString() {
        return "CP:" + this.name;
    }
}

