/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import ua.com.softway.tracker.i18n.ResourceLocation;
import ua.com.softway.tracker.util.Strings;

class Bundle {
    private final ResourceLocation location;
    private final Map<String, String> properties = new HashMap<String, String>();
    private long lastModified = -1L;

    public Bundle(ResourceLocation location) {
        this.location = location;
        this.load();
    }

    private void load() {
        InputStream resourceStream = this.location.getInputStream();
        if (resourceStream == null) {
            throw new RuntimeException("Can't find resource '" + this.location + "'");
        }
        try {
            String s;
            InputStreamReader streamReader = new InputStreamReader(resourceStream, "UTF-8");
            BufferedReader reader = new BufferedReader(streamReader);
            int line = 0;
            while ((s = reader.readLine()) != null) {
                if (Strings.isBlank(s) || s.startsWith("#")) continue;
                this.addPropertyToBundle(++line, s);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addPropertyToBundle(int line, String s) {
        int pos = s.indexOf(61);
        if (pos == -1) {
            System.out.println("Illegal property definition in " + this.location + ", line " + line);
            return;
        }
        String key = s.substring(0, pos);
        String value = s.substring(pos + 1);
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        if (this.isModified()) {
            this.properties.clear();
            try {
                this.load();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.properties.get(key);
    }

    private boolean isModified() {
        if (this.lastModified == -1L) {
            this.lastModified = this.location.lastModified();
        } else if (this.lastModified != this.location.lastModified()) {
            this.lastModified = this.location.lastModified();
            return true;
        }
        return false;
    }

    public String toString() {
        return "Bundle{" + this.location + "}";
    }
}

