/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.fs.nativefs;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.fs.FileSystemException;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.fs.nativefs.NativeFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeFolder
implements Folder {
    private final java.io.File file;

    NativeFolder(java.io.File file) {
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public List<File> getFiles() {
        this.mkdirs();
        String[] names = this.file.list();
        if (names == null) {
            throw new FileSystemException("Path doesn't not denote a directory '" + this.file + "'");
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String name : names) {
            java.io.File file = new java.io.File(this.file, name);
            if (file.isDirectory()) continue;
            result.add(new NativeFile(file));
        }
        return result;
    }

    @Override
    public List<Folder> getFolders() {
        ArrayList<Folder> result = new ArrayList<Folder>();
        for (java.io.File child : this.file.listFiles()) {
            if (!child.isDirectory()) continue;
            result.add(this.getFolder(child.getName()));
        }
        return result;
    }

    @Override
    public File getFile(String name) {
        this.mkdirs();
        return new NativeFile(new java.io.File(this.file, name));
    }

    @Override
    public Folder getFolder(String name) {
        return new NativeFolder(new java.io.File(this.file, name));
    }

    @Override
    public void mkdirs() {
        if (this.file.mkdirs() && !this.file.exists()) {
            throw new FileSystemException("cannot create folder " + this.file.getAbsolutePath());
        }
    }

    private static void delete(java.io.File file) {
        if (file.isDirectory()) {
            String[] names;
            for (String name : names = file.list()) {
                java.io.File f = new java.io.File(file, name);
                NativeFolder.delete(f);
            }
        }
        file.delete();
    }

    @Override
    public void delete() {
        NativeFolder.delete(this.file);
        if (this.file.exists()) {
            throw new FileSystemException("cannot delete folder " + this.file.getAbsolutePath());
        }
    }

    public String toString() {
        return "Folder{" + this.file.getAbsolutePath() + "}";
    }
}

