/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.fs.nativefs;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import ua.com.softway.tracker.fs.File;
import ua.com.softway.tracker.fs.FileSystemException;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.fs.nativefs.NativeFolder;

class NativeFile
implements File {
    private final java.io.File file;

    NativeFile(java.io.File file) {
        this.file = file;
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public Reader openReader() {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8");
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    public InputStream openInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new FileSystemException(e);
        }
    }

    public void delete() {
        if (!this.file.delete()) {
            throw new FileSystemException("Can't delete file '" + this.file + "'");
        }
    }

    public Writer openWriter() {
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream openOutputStream() {
        try {
            return new FileOutputStream(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPath() {
        return this.file.getAbsolutePath();
    }

    public String toString() {
        return "File{" + this.file.getAbsolutePath() + "}";
    }

    public Folder getParent() {
        return new NativeFolder(this.file.getParentFile());
    }

    public long lastModified() {
        return this.file.lastModified();
    }
}

