/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.events.action;

import java.util.ArrayList;
import java.util.List;
import lime.NamespacePath;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.action.SelectOptions;
import ua.com.softway.tracker.action.issue.CurrentProject;
import ua.com.softway.tracker.events.EventDay;
import ua.com.softway.tracker.events.EventRecorder;
import ua.com.softway.tracker.events.action.EventDayView;
import ua.com.softway.tracker.ui.SelectOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class TimelineAction {
    private final EventRecorder events;
    public String projectKey;
    public String startDay;

    public TimelineAction(EventRecorder events, CurrentProject currentProject) {
        this.events = events;
        this.projectKey = currentProject.getCurrentProject().getKey();
    }

    public String display() {
        return "timeline";
    }

    public String getPrevStartDay() {
        if (this.getStartDay() > 0) {
            return "" + (this.getStartDay() - 7);
        }
        return null;
    }

    public String getNextStartDay() {
        if (this.getStartDay() < this.events.getEventDays().size() - 7) {
            return "" + (this.getStartDay() + 7);
        }
        return null;
    }

    private int getStartDay() {
        if (this.startDay != null) {
            return Integer.parseInt(this.startDay);
        }
        return 0;
    }

    public List<SelectOption> getProjectOptions() {
        return SelectOptions.project(Tracker.instance().getVisibleProjects(), true);
    }

    public List<EventDayView> getEventDays() {
        if (this.getStartDay() >= this.events.getEventDays().size()) {
            return new ArrayList<EventDayView>();
        }
        int endDay = Math.min(this.events.getEventDays().size(), this.getStartDay() + 7);
        ArrayList<EventDayView> eventDays = new ArrayList<EventDayView>();
        for (EventDay day : this.events.getEventDays().subList(this.getStartDay(), endDay)) {
            EventDayView eventDayView = new EventDayView(day, this.projectKey);
            if (eventDayView.getEvents().isEmpty()) continue;
            eventDays.add(eventDayView);
        }
        return eventDays;
    }
}

