/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.events.action;

import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.issue.IssueTextRenderer;
import ua.com.softway.tracker.events.Event;
import ua.com.softway.tracker.events.IssueEvent;
import ua.com.softway.tracker.i18n.Resources;

public class EventView {
    private final Event event;

    public EventView(Event event) {
        this.event = event;
    }

    public String getTime() {
        return User.currentUser().getDateFormat().formatTime(this.event.getDate());
    }

    public String getTitle() {
        if (this.event instanceof IssueEvent) {
            IssueEvent issueEvent = (IssueEvent)this.event;
            String text = Resources.getText(issueEvent.getAction(), issueEvent.getUserName(), issueEvent.getIssueKey());
            return new IssueTextRenderer().render(text);
        }
        return "Generic Event";
    }

    public String getDetails() {
        return new IssueTextRenderer().render(this.event.getDetails());
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventView other = (EventView)obj;
        return !(this.event == null ? other.event != null : !this.event.equals(other.event));
    }

    public String toString() {
        return this.event.toString();
    }
}

