/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.events.action;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.events.Event;
import ua.com.softway.tracker.events.EventDay;
import ua.com.softway.tracker.events.action.EventView;
import ua.com.softway.tracker.ui.SelectOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDayView {
    private final EventDay day;
    private final String projectKey;

    public EventDayView(EventDay day, String projectKey) {
        this.day = day;
        this.projectKey = projectKey;
    }

    public List<EventView> getEvents() {
        ArrayList<EventView> events = new ArrayList<EventView>();
        List<Project> projects = Tracker.instance().getVisibleProjects();
        for (Event event : this.day.getEvents()) {
            if (this.projectKey.equals(SelectOption.NONE_OPTION.value) ? !projects.contains(Tracker.instance().getProject(event.getProjectKey())) : !this.projectKey.equals(event.getProjectKey())) continue;
            events.add(new EventView(event));
        }
        return events;
    }

    public String getName() {
        return User.currentUser().getDateFormat().formatDay(this.day.getDate());
    }

    public String toString() {
        return this.day.toString();
    }
}

