/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.events;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import ua.com.softway.tracker.SystemSettings;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.events.Email;

public class PasswordResetEmail
implements Email {
    private final User user;
    private final String password;

    public PasswordResetEmail(User user, String password) {
        this.user = user;
        this.password = password;
    }

    public Message getMessage(Session session, SystemSettings emailSettings) throws MessagingException {
        StringBuffer text = new StringBuffer();
        text.append("You (or someone else) has reset your password.\n\n");
        text.append("Your login: " + this.user.getLogin() + "\n");
        text.append("Your new password: " + this.password + "\n\n");
        text.append("You can your password later by logging in and pressing link 'Edit Profile' on home page.\n\n");
        text.append(emailSettings.getSignature());
        MimeMessage message = new MimeMessage(session);
        message.setSubject("[Clarity] Your new password");
        message.setFrom(new InternetAddress(emailSettings.getFromEmail()));
        message.setRecipient(MimeMessage.RecipientType.TO, new InternetAddress(this.user.getEmail()));
        message.setText(text.toString());
        return message;
    }
}

