/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.events;

import java.util.concurrent.BlockingQueue;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import lime.Lime;
import ua.com.softway.tracker.SystemSettings;
import ua.com.softway.tracker.events.Email;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MailerThread
extends Thread {
    private final BlockingQueue<Email> emails;
    private final SystemSettings emailSettings;
    private final String contextPath;

    public MailerThread(String contextPath, BlockingQueue<Email> emails, SystemSettings emailSettings) {
        this.contextPath = contextPath;
        this.emails = emails;
        this.emailSettings = emailSettings;
        this.setName("mailer");
    }

    @Override
    public void run() {
        Lime.init(this.contextPath);
        while (true) {
            Email email;
            try {
                email = this.emails.take();
            }
            catch (InterruptedException e1) {
                return;
            }
            Session session = this.emailSettings.getMailSession();
            if (session == null) continue;
            try {
                Message message = email.getMessage(session, this.emailSettings);
                Transport.send(message);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

