/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.events.Email;
import ua.com.softway.tracker.events.Notification;
import ua.com.softway.tracker.events.NotificationEmail;
import ua.com.softway.tracker.events.UpdatedField;
import ua.com.softway.tracker.i18n.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IssueNotification
implements Notification {
    private final Issue issue;
    private final String action;
    private final List<UpdatedField> fields;
    private final Comment comment;

    public IssueNotification(Issue issue, String action) {
        this(issue, action, new ArrayList<UpdatedField>(), null);
    }

    public IssueNotification(Issue issue, String action, List<UpdatedField> fields, Comment comment) {
        this.issue = issue;
        this.action = action;
        this.fields = fields;
        this.comment = comment;
    }

    @Override
    public MimeMessage getMessage(User userFrom, User to, Session session, String fromEmail, String signature, String trackerUrl) throws MessagingException {
        String from = userFrom.getName() + " (Clarity) <" + fromEmail + ">";
        String subject = IssueNotification.getSubject(this.issue, userFrom, this.action);
        StringBuffer text = new StringBuffer();
        if (this.comment != null) {
            text.append(this.comment.getText());
            text.append("\n --- \n");
        }
        IssueNotification.appendIssueInfo(text, this.issue, trackerUrl, this.fields);
        text.append(signature);
        MimeMessage message = new MimeMessage(session);
        message.setSubject(subject);
        message.setText(text.toString());
        message.setFrom(new InternetAddress(from));
        message.setRecipient(MimeMessage.RecipientType.TO, new InternetAddress(to.getEmail()));
        return message;
    }

    static String getSubject(Issue issue, User userFrom, String action) {
        StringBuffer sb = new StringBuffer();
        sb.append("[Clarity] ");
        sb.append(Resources.getText(action, userFrom.getName(), Resources.getText("event.issue")));
        sb.append(" (");
        sb.append(issue.getKey());
        sb.append(") ");
        sb.append(issue.getSummary());
        return sb.toString();
    }

    static void appendIssueInfo(StringBuffer buffer, Issue issue, String trackerUrl, List<UpdatedField> fields) {
        Map<String, UpdatedField> f = IssueNotification.getFieldMap(fields);
        buffer.append(Resources.getText("notification.summary"));
        buffer.append(' ');
        buffer.append(issue.getSummary());
        if (f.containsKey("summary")) {
            buffer.append(" (" + Resources.getText("notification.was") + " ");
            buffer.append(f.get("summary").getOldValue());
            buffer.append(")");
        }
        buffer.append("\n" + Resources.getText("notification.key"));
        buffer.append(' ');
        buffer.append(issue.getKey());
        buffer.append("\n" + Resources.getText("notification.project"));
        buffer.append(' ');
        buffer.append(issue.getProject().getName());
        buffer.append("\n" + Resources.getText("notification.url"));
        buffer.append(' ');
        buffer.append(trackerUrl + Pages.viewIssue(issue.getKey()));
        buffer.append("\n" + Resources.getText("notification.type"));
        buffer.append(' ');
        buffer.append(issue.getType().localizedName());
        if (f.containsKey("type")) {
            String oldType = f.get("type").getOldValue();
            buffer.append(" (" + Resources.getText("notification.was") + " ");
            buffer.append(oldType);
            buffer.append(")");
        }
        buffer.append("\n" + Resources.getText("notification.status"));
        buffer.append(' ');
        buffer.append(issue.getStatus().toString().toLowerCase());
        buffer.append("\n");
        buffer.append("\n" + Resources.getText("notification.priority"));
        buffer.append(' ');
        buffer.append(issue.getPriority().localizedName());
        if (f.containsKey("priority")) {
            String oldPriority = f.get("priority").getOldValue();
            buffer.append(" (" + Resources.getText("notification.was") + " ");
            buffer.append(oldPriority);
            buffer.append(")");
        }
        buffer.append("\n" + Resources.getText("notification.affects"));
        buffer.append(' ');
        if (issue.getAffects() != null) {
            buffer.append(issue.getAffects().getName());
        } else {
            buffer.append(Resources.getText("notification.unknown"));
        }
        if (f.containsKey("affects")) {
            String oldAffects = f.get("affects").getOldValue();
            buffer.append(" (" + Resources.getText("notification.was") + " ");
            if (oldAffects == null) {
                buffer.append(Resources.getText("notification.unknown"));
            } else {
                buffer.append(oldAffects);
            }
            buffer.append(")");
        }
        buffer.append("\n" + Resources.getText("notification.fix"));
        buffer.append(' ');
        if (issue.getFix() != null) {
            buffer.append(issue.getFix().getName());
        } else {
            buffer.append(Resources.getText("notification.unknown"));
        }
        if (f.containsKey("fix")) {
            String oldFix = f.get("fix").getOldValue();
            buffer.append(" (" + Resources.getText("notification.was") + " ");
            if (oldFix == null) {
                buffer.append(Resources.getText("notification.unknown"));
            } else {
                buffer.append(oldFix);
            }
            buffer.append(")");
        }
        if (issue.getReporter() != null) {
            buffer.append("\n" + Resources.getText("notification.reporter"));
            buffer.append(' ');
            buffer.append(issue.getReporter().getName());
            if (f.get("reporter") != null) {
                String oldReporter = f.get("reporter").getOldValue();
                buffer.append(" (" + Resources.getText("notification.was") + " ");
                if (oldReporter == null) {
                    buffer.append(Resources.getText("notification.unspecified"));
                } else {
                    buffer.append(oldReporter);
                }
                buffer.append(")");
            }
        }
        if (issue.getAssignee() != null) {
            buffer.append("\n" + Resources.getText("notification.assignee"));
            buffer.append(' ');
            buffer.append(issue.getAssignee().getName());
            if (f.get("assignee") != null) {
                String oldAssignee = f.get("assignee").getOldValue();
                buffer.append(" (" + Resources.getText("notification.was") + " ");
                if (oldAssignee == null) {
                    buffer.append(Resources.getText("notification.unassigned"));
                } else {
                    buffer.append(oldAssignee);
                }
                buffer.append(")");
            }
        }
        if (issue.getEstimate() != null) {
            buffer.append("\n" + Resources.getText("notification.estimate"));
            buffer.append(' ');
            buffer.append(issue.getEstimate().toLocalString());
            if (f.get("estimate") != null) {
                String oldEstimate = f.get("estimate").getOldValue();
                buffer.append(" (" + Resources.getText("notification.was") + " ");
                if (oldEstimate == null) {
                    buffer.append(Resources.getText("notification.unspecified"));
                } else {
                    buffer.append(oldEstimate);
                }
                buffer.append(")");
            }
        }
        if (issue.getResolution() != null) {
            buffer.append("\n" + Resources.getText("notification.resolution"));
            buffer.append(' ');
            buffer.append(issue.getResolution().getName());
            if (f.get("resolution") != null) {
                String oldResolution = f.get("resolution").getOldValue();
                buffer.append(" (" + Resources.getText("notification.was") + " ");
                if (oldResolution == null) {
                    buffer.append(Resources.getText("notification.unspecified"));
                } else {
                    buffer.append(oldResolution);
                }
                buffer.append(")");
            }
        }
        buffer.append("\n\n");
        if (issue.getDescription() != null) {
            buffer.append('\n');
            buffer.append(issue.getDescription());
        }
        if (f.containsKey("description")) {
            buffer.append("\n");
            buffer.append(Resources.getText("notification.was"));
            buffer.append(":\n");
            buffer.append(f.get("description"));
        }
        buffer.append('\n');
    }

    private static Map<String, UpdatedField> getFieldMap(List<UpdatedField> fields) {
        HashMap<String, UpdatedField> result = new HashMap<String, UpdatedField>();
        for (UpdatedField field : fields) {
            result.put(field.getName(), field);
        }
        return result;
    }

    @Override
    public List<? extends Email> createEmails() {
        ArrayList<NotificationEmail> result = new ArrayList<NotificationEmail>();
        HashSet<User> users = new HashSet<User>(this.issue.getWatchers());
        if (this.issue.getAssignee() != null && (!this.issue.getAssignee().equals(User.currentUser()) || User.currentUser().getPreferences().isEmailMyChangesToMe())) {
            users.add(this.issue.getAssignee());
        }
        if (this.issue.getReporter() != null && (!this.issue.getReporter().equals(User.currentUser()) || User.currentUser().getPreferences().isEmailMyChangesToMe())) {
            users.add(this.issue.getReporter());
        }
        if (this.issue.getProject().getDefaultAssignee() != null && (!this.issue.getProject().getDefaultAssignee().equals(User.currentUser()) || User.currentUser().getPreferences().isEmailMyChangesToMe())) {
            users.add(this.issue.getProject().getDefaultAssignee());
        }
        for (User user : users) {
            result.add(new NotificationEmail(this, User.currentUser(), user));
        }
        return result;
    }
}

