/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.events;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.events.Event;
import ua.com.softway.tracker.events.UpdatedField;
import ua.com.softway.tracker.i18n.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueEvent
extends Event {
    private Issue issue;
    private String issueKey;
    private String action;
    private List<UpdatedField> updatedFields = new ArrayList<UpdatedField>();
    private String commentKey;

    public IssueEvent() {
        if (User.currentUser() != null) {
            this.setUserName(User.currentUser().getName());
        }
    }

    public IssueEvent(Issue issue, String action) {
        this();
        this.setIssue(issue);
        this.setAction(action);
    }

    public IssueEvent(Issue issue, String action, Comment comment) {
        this();
        this.setIssue(issue);
        this.setAction(action);
        this.setComment(comment);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getCommentKey() {
        return this.commentKey;
    }

    public void setCommentKey(String commentKey) {
        this.commentKey = commentKey;
    }

    public void setComment(Comment comment) {
        if (comment != null) {
            this.setCommentKey(comment.getKey());
        }
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
        this.setProjectKey(issue.getProject().getKey());
        this.setIssueKey(issue.getKey());
    }

    @Override
    public String getAdditionalInfo() {
        if (this.updatedFields == null || this.updatedFields.isEmpty()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (UpdatedField field : this.updatedFields) {
            result.append(Resources.getText("issue." + field.getName()));
            result.append(' ');
            result.append(Resources.getText("event.field.was"));
            result.append(' ');
            result.append('\'');
            result.append(field.getOldValue());
            result.append('\'');
            result.append(' ');
            result.append(Resources.getText("event.field.setTo"));
            result.append(' ');
            result.append('\'');
            result.append(field.getNewValue());
            result.append('\'');
            result.append('\n');
        }
        return result.toString();
    }

    public List<UpdatedField> getUpdatedFields() {
        return this.updatedFields;
    }

    public void setUpdatedFields(List<UpdatedField> updatedFields) {
        this.updatedFields = updatedFields;
    }
}

