/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.events;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.events.Event;
import ua.com.softway.tracker.events.EventDay;
import ua.com.softway.tracker.events.EventDaySerializer;
import ua.com.softway.tracker.events.IssueEvent;
import ua.com.softway.tracker.events.TrackerEventListener;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.storage.ObjectDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRecorder
implements TrackerEventListener {
    private List<Event> events = new ArrayList<Event>();
    private ObjectDirectory<EventDay> dayDirectory;

    public EventRecorder(Folder eventFolder) {
        this.dayDirectory = new ObjectDirectory<EventDay>(new EventDaySerializer(), eventFolder);
        for (EventDay day : this.dayDirectory.getObjects().values()) {
            this.events.addAll(day.getEvents());
        }
        Collections.sort(this.events);
    }

    public List<Event> getEvents() {
        return this.events;
    }

    @Override
    public void event(Event event) {
        this.events.add(0, event);
        EventDay lastDay = this.getEventDay(EventRecorder.justDay(event.getDate()));
        this.dayDirectory.saveOrUpdate(lastDay);
    }

    public EventDay getEventDay(Date day) {
        for (EventDay eventDay : this.getEventDays()) {
            if (!day.equals(eventDay.getDate())) continue;
            return eventDay;
        }
        return new EventDay(day);
    }

    public List<EventDay> getEventDays() {
        ArrayList<EventDay> eventDays = new ArrayList<EventDay>();
        for (Event event : this.getEvents()) {
            EventDay lastDay;
            if (eventDays.isEmpty()) {
                lastDay = new EventDay(EventRecorder.justDay(event.getDate()));
                eventDays.add(lastDay);
            } else {
                lastDay = (EventDay)eventDays.get(eventDays.size() - 1);
                if (!lastDay.getDate().equals(EventRecorder.justDay(event.getDate()))) {
                    lastDay = new EventDay(EventRecorder.justDay(event.getDate()));
                    eventDays.add(lastDay);
                }
            }
            lastDay.addEvent(event);
        }
        return eventDays;
    }

    private static Date justDay(Date date) {
        Calendar old = GregorianCalendar.getInstance();
        old.setTime(date);
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.set(1, old.get(1));
        calendar.set(2, old.get(2));
        calendar.set(5, old.get(5));
        return calendar.getTime();
    }

    public List<IssueEvent> getEvents(Issue issue) {
        ArrayList<IssueEvent> result = new ArrayList<IssueEvent>();
        for (Event event : this.getEvents()) {
            IssueEvent issueEvent;
            if (!(event instanceof IssueEvent) || !(issueEvent = (IssueEvent)event).getIssueKey().equals(issue.getKey())) continue;
            result.add(issueEvent);
        }
        return result;
    }
}

