/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.events;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ua.com.softway.tracker.events.Event;
import ua.com.softway.tracker.events.EventDay;
import ua.com.softway.tracker.events.IssueEvent;
import ua.com.softway.tracker.events.UpdatedField;
import ua.com.softway.tracker.storage.ObjectUpdater;
import ua.com.softway.tracker.storage.Properties;
import ua.com.softway.tracker.storage.Serializer;
import ua.com.softway.tracker.storage.StorageDateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventDaySerializer
implements Serializer<EventDay> {
    private static final SimpleDateFormat keyFormat = new SimpleDateFormat("yyyyMMdd");

    EventDaySerializer() {
    }

    @Override
    public String getKey(EventDay object) {
        return keyFormat.format(object.getDate());
    }

    @Override
    public EventDay load(ObjectUpdater<EventDay> updater, Properties properties, String key) {
        Date date = StorageDateTimeFormat.parse(properties.getProperty("date"));
        EventDay day = new EventDay(date);
        List<Properties> events = properties.getList("events");
        for (Properties eventProperties : events) {
            String type = eventProperties.getProperty("type");
            String projectKey = eventProperties.getProperty("projectKey");
            String userName = eventProperties.getProperty("userName");
            Date eventDate = StorageDateTimeFormat.parse(eventProperties.getProperty("date"));
            if (type.equals(IssueEvent.class.getName())) {
                String action = eventProperties.getProperty("action");
                String issueKey = eventProperties.getProperty("issueKey");
                String details = eventProperties.getProperty("details");
                String commentKey = eventProperties.getProperty("commentKey");
                ArrayList<UpdatedField> updatedFields = new ArrayList<UpdatedField>();
                for (Properties fieldProperties : eventProperties.getList("updatedFields")) {
                    String name = fieldProperties.getProperty("name");
                    String oldValue = fieldProperties.getProperty("oldValue");
                    String newValue = fieldProperties.getProperty("newValue");
                    updatedFields.add(new UpdatedField(name, oldValue, newValue));
                }
                IssueEvent event = new IssueEvent();
                event.setProjectKey(projectKey);
                event.setUserName(userName);
                event.setDate(eventDate);
                event.setAction(action);
                event.setIssueKey(issueKey);
                event.setDetails(details);
                event.setCommentKey(commentKey);
                event.setUpdatedFields(updatedFields);
                day.addEvent(event);
                continue;
            }
            Event event = new Event(projectKey, userName, eventDate);
            day.addEvent(event);
        }
        return day;
    }

    @Override
    public void save(Properties properties, EventDay object) {
        properties.addProperty("date", StorageDateTimeFormat.format(object.getDate()));
        List<Properties> events = properties.addList("events", "event");
        for (Event event : object.getEvents()) {
            Properties eventProperties = new Properties();
            eventProperties.addProperty("type", event.getClass().getName());
            eventProperties.addProperty("projectKey", event.getProjectKey());
            eventProperties.addProperty("userName", event.getUserName());
            eventProperties.addProperty("date", StorageDateTimeFormat.format(event.getDate()));
            if (event instanceof IssueEvent) {
                IssueEvent issueEvent = (IssueEvent)event;
                eventProperties.addProperty("action", issueEvent.getAction());
                eventProperties.addProperty("issueKey", issueEvent.getIssueKey());
                eventProperties.addProperty("details", issueEvent.getDetails());
                eventProperties.addProperty("commentKey", issueEvent.getCommentKey());
                if (issueEvent.getUpdatedFields() != null && !issueEvent.getUpdatedFields().isEmpty()) {
                    List<Properties> fields = eventProperties.addList("updatedFields", "updatedField");
                    for (UpdatedField field : issueEvent.getUpdatedFields()) {
                        Properties fieldProperties = new Properties();
                        fieldProperties.addProperty("name", field.getName());
                        fieldProperties.addProperty("oldValue", field.getOldValue());
                        fieldProperties.addProperty("newValue", field.getNewValue());
                        fields.add(fieldProperties);
                    }
                }
            }
            events.add(eventProperties);
        }
    }
}

