/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.configuration;

import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.configuration.ConfigurationSerializer;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.fs.nativefs.NativeFileSystem;
import ua.com.softway.tracker.license.LicenseKey;
import ua.com.softway.tracker.startup.FileCaseChecker;
import ua.com.softway.tracker.util.Backup;
import ua.com.softway.tracker.wiki.Wiki;

public class TrackerConfiguration {
    private final String configurationKey;
    private String dataFolder;
    private String backupFolder;
    private LicenseKey licenseKey;

    public TrackerConfiguration(String configurationKey) {
        this.configurationKey = configurationKey;
    }

    public boolean isConfigured() {
        return this.getDataFolder() != null;
    }

    public String getDataFolder() {
        return this.dataFolder;
    }

    public void setDataFolder(String dataFolder) {
        this.dataFolder = dataFolder;
    }

    public String getBackupFolder() {
        return this.backupFolder;
    }

    public void setBackupFolder(String backupFolder) {
        this.backupFolder = backupFolder;
    }

    public LicenseKey getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(LicenseKey licenseKey) {
        this.licenseKey = licenseKey;
    }

    public void initTracker() {
        NativeFileSystem fileSystem = new NativeFileSystem();
        Folder trackerFolder = fileSystem.getFolder(this.getDataFolder());
        FileCaseChecker fileCaseChecker = new FileCaseChecker(trackerFolder.getFile("FileCaseChecker"));
        if (!fileCaseChecker.check()) {
            throw new RuntimeException("Wrong file name case in tracker's data folder. Please restore data from backup.");
        }
        Tracker.configure(trackerFolder);
        Folder backupFolder = fileSystem.getFolder(this.getBackupFolder());
        new Backup(backupFolder, trackerFolder).start();
        Wiki.configure(trackerFolder.getFolder("wiki"));
    }

    String getConfigurationKey() {
        return this.configurationKey;
    }

    public void save() {
        ConfigurationSerializer.save(this);
    }
}

