/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.configuration;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import ua.com.softway.tracker.configuration.ConfigurationSerializer;
import ua.com.softway.tracker.configuration.TrackerConfiguration;

public class Configurator {
    private static TrackerConfiguration configuration;

    public static TrackerConfiguration getConfiguration() {
        return configuration;
    }

    public static void setConfiguration(TrackerConfiguration configuration) {
        Configurator.configuration = configuration;
    }

    public static TrackerConfiguration initConfiguration(HttpServletRequest request) throws MalformedURLException {
        String key = Configurator.getConfigurationKey(request);
        configuration = ConfigurationSerializer.loadConfiguration(key);
        if (configuration != null) {
            configuration.initTracker();
        } else {
            configuration = new TrackerConfiguration(key);
        }
        return configuration;
    }

    private static String getConfigurationKey(HttpServletRequest request) throws MalformedURLException {
        URL url = new URL(request.getRequestURL().toString());
        String key = url.getHost() + "_" + request.getContextPath().replace('/', '_');
        return key;
    }
}

