/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.configuration;

import java.io.File;
import ua.com.softway.tracker.configuration.TrackerConfiguration;
import ua.com.softway.tracker.fs.Folder;
import ua.com.softway.tracker.fs.nativefs.NativeFileSystem;
import ua.com.softway.tracker.license.InvalidKeyException;
import ua.com.softway.tracker.license.LicenseKey;
import ua.com.softway.tracker.license.LicenseKeySerializer;
import ua.com.softway.tracker.storage.Properties;
import ua.com.softway.tracker.storage.Xml;

class ConfigurationSerializer {
    ConfigurationSerializer() {
    }

    private static Folder getConfigurationRoot() {
        String userHome = System.getProperty("user.home");
        return NativeFileSystem.fromFolder(new File(userHome, ".clarity"));
    }

    public static void save(TrackerConfiguration configuration) {
        ua.com.softway.tracker.fs.File configurationFile = ConfigurationSerializer.getConfigurationRoot().getFile(configuration.getConfigurationKey());
        Properties properties = new Properties();
        properties.addProperty("backupFolder", configuration.getBackupFolder());
        properties.addProperty("dataFolder", configuration.getDataFolder());
        properties.addProperty("licenseKey", LicenseKeySerializer.toString(configuration.getLicenseKey()));
        Xml.save(configurationFile, "configuration", properties);
    }

    public static void delete(String configurationKey) {
        ua.com.softway.tracker.fs.File configurationFile = ConfigurationSerializer.getConfigurationRoot().getFile(configurationKey);
        if (configurationFile.exists()) {
            configurationFile.delete();
        }
    }

    public static TrackerConfiguration loadConfiguration(String configurationKey) {
        ua.com.softway.tracker.fs.File configurationFile = ConfigurationSerializer.getConfigurationRoot().getFile(configurationKey);
        if (!configurationFile.exists()) {
            return null;
        }
        TrackerConfiguration configuration = new TrackerConfiguration(configurationKey);
        String licenseKey = null;
        try {
            Properties properties = Xml.load(configurationFile);
            configuration.setBackupFolder(properties.getProperty("backupFolder"));
            configuration.setDataFolder(properties.getProperty("dataFolder"));
            licenseKey = properties.getProperty("licenseKey");
        }
        catch (RuntimeException e) {
            return null;
        }
        try {
            LicenseKey key = LicenseKeySerializer.fromString(licenseKey);
            configuration.setLicenseKey(key);
        }
        catch (InvalidKeyException e) {
            // empty catch block
        }
        return configuration;
    }
}

