/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.configuration;

import java.io.File;
import java.net.MalformedURLException;
import lime.NamespacePath;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.configuration.Configurator;
import ua.com.softway.tracker.configuration.TrackerConfiguration;
import ua.com.softway.tracker.license.InvalidKeyException;
import ua.com.softway.tracker.license.LicenseKey;
import ua.com.softway.tracker.license.LicenseKeySerializer;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.util.Strings;

@NamespacePath(value="/configuration")
public class ConfigurationAction {
    public String dataFolder = "";
    public String backupFolder = "";
    public String login = "";
    public String password = "";
    public String confirmPassword = "";
    public String registrationKey = "";
    public Messages messages = new Messages();

    public String display() {
        return "configuration";
    }

    public Object save() throws MalformedURLException {
        File file;
        if (Strings.isBlank(this.dataFolder)) {
            this.messages.addMessage("configuration.dataFolder.empty", new Object[0]);
        } else {
            file = new File(this.dataFolder);
            if (file.exists()) {
                this.messages.addMessage("configuration.dataFolder.exist", new Object[0]);
            } else if (!file.mkdirs()) {
                this.messages.addMessage("configuration.dataFolder.noaccess", new Object[0]);
            } else {
                file.delete();
            }
        }
        if (Strings.isBlank(this.backupFolder)) {
            this.messages.addMessage("configuration.backupFolder.empty", new Object[0]);
        } else {
            file = new File(this.backupFolder);
            if (file.exists()) {
                this.messages.addMessage("configuration.backupFolder.exist", new Object[0]);
            } else if (!file.mkdirs()) {
                this.messages.addMessage("configuration.backupFolder.noaccess", new Object[0]);
            } else {
                file.delete();
            }
        }
        if (Strings.isBlank(this.login)) {
            this.messages.addMessage("configuration.login.empty", new Object[0]);
        }
        if (!Strings.isValidLogin(this.login)) {
            this.messages.addMessage("configuration.login.invalid", new Object[0]);
        }
        if (Strings.isBlank(this.password)) {
            this.messages.addMessage("configuration.password.empty", new Object[0]);
        } else if (!this.password.equals(this.confirmPassword)) {
            this.messages.addMessage("configuration.password.mismatch", new Object[0]);
        }
        LicenseKey key = null;
        try {
            key = LicenseKeySerializer.fromString(this.registrationKey);
        }
        catch (InvalidKeyException e) {
            this.messages.addMessage("configuration.invalidKey", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return "configuration";
        }
        TrackerConfiguration configuration = Configurator.getConfiguration();
        configuration.setBackupFolder(this.backupFolder);
        configuration.setDataFolder(this.dataFolder);
        configuration.setLicenseKey(key);
        configuration.save();
        configuration.initTracker();
        Tracker tracker = Tracker.instance();
        User admin = tracker.createUser(this.login, this.password, "nosuchemail@nosuchdomain.com", "System User");
        tracker.getAdministratorsGroup().addUser(admin);
        tracker.getAdministratorsGroup().store();
        return Pages.logout();
    }
}

