/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.manage;

import java.util.Date;
import java.util.List;
import lime.NamespacePath;
import lime.outcome.Redirect;
import ua.com.softway.tracker.DuplicateNameException;
import ua.com.softway.tracker.NoSuchProject;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.ui.Message;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class VersionAction {
    private Tracker tracker;
    public Messages messages = new Messages();
    public String projectKey;
    public String name = "";
    public String plannedTo = "";

    public VersionAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public Object versionList() {
        Project project = this.tracker.getProject(this.projectKey);
        if (project == null) {
            return new NoSuchProject(this.projectKey);
        }
        if (!project.getPermissions().canManageVersions()) {
            return new Message("no.permissions", new Object[0]);
        }
        return "manage/versionList";
    }

    public List<Version> getVersions() {
        return this.tracker.getProject(this.projectKey).getVersions();
    }

    public Object addVersion() {
        Project project = this.tracker.getProject(this.projectKey);
        if (project == null) {
            return new NoSuchProject(this.projectKey);
        }
        if (Strings.isBlank(this.name)) {
            this.messages.addMessage("version.name.empty", new Object[0]);
        }
        if (!User.currentUser().getDateFormat().isValidDate(this.plannedTo)) {
            this.messages.addMessage("version.plannedDate.format", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return "manage/versionList";
        }
        Date plannedToDate = User.currentUser().getDateFormat().parseDate(this.plannedTo);
        try {
            project.addVersion(new Version(this.name, plannedToDate));
            project.store();
        }
        catch (DuplicateNameException e) {
            this.messages.addMessage("version.name.duplicate", new Object[0]);
            return "manage/versionList";
        }
        return Pages.versionList(this.projectKey);
    }

    public Redirect removeVersion() {
        Project project = this.tracker.getProject(this.projectKey);
        project.deleteVersion(this.name);
        project.store();
        return Pages.versionList(this.projectKey);
    }

    public Redirect up() {
        Version version;
        Project project = this.tracker.getProject(this.projectKey);
        int pos = project.getVersionPosition(version = project.getVersion(this.name));
        if (pos > 0) {
            project.setVersionPosition(version, pos - 1);
            project.store();
        }
        return Pages.versionList(this.projectKey);
    }

    public Redirect down() {
        Version version;
        Project project = this.tracker.getProject(this.projectKey);
        int pos = project.getVersionPosition(version = project.getVersion(this.name));
        if (pos < project.getVersions().size() - 1) {
            project.setVersionPosition(version, pos + 1);
            project.store();
        }
        return Pages.versionList(this.projectKey);
    }

    public Redirect top() {
        Project project = this.tracker.getProject(this.projectKey);
        Version version = project.getVersion(this.name);
        project.setVersionPosition(version, 0);
        project.store();
        return Pages.versionList(this.projectKey);
    }

    public Redirect bottom() {
        Project project = this.tracker.getProject(this.projectKey);
        Version version = project.getVersion(this.name);
        project.setVersionPosition(version, project.getVersions().size() - 1);
        project.store();
        return Pages.versionList(this.projectKey);
    }

    public boolean canUp(Version version) {
        return this.tracker.getProject(this.projectKey).getVersionPosition(version) > 0;
    }

    public boolean canDown(Version version) {
        return this.tracker.getProject(this.projectKey).getVersionPosition(version) < this.getVersions().size() - 1;
    }
}

