/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.manage;

import java.util.List;
import lime.NamespacePath;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.manage.UserForm;
import ua.com.softway.tracker.configuration.Configurator;
import ua.com.softway.tracker.license.LicenseKey;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker/admin")
public class UserAction {
    private final Tracker tracker;
    public UserForm userForm = new UserForm();
    public Messages messages = new Messages();

    public UserAction(Tracker users) {
        this.tracker = users;
    }

    public String userList() {
        return "manage/userList";
    }

    public List<User> getUsers() {
        return this.tracker.getUsers();
    }

    public String getUsersUsage() {
        LicenseKey key = Configurator.getConfiguration().getLicenseKey();
        if (!key.isUsersCountLimited()) {
            return null;
        }
        return this.tracker.getUsers().size() + " / " + key.getUsersCount();
    }

    public String userForm() {
        User user = this.tracker.getUser(this.userForm.login);
        if (user != null) {
            this.userForm.editing = true;
            this.userForm.email = user.getEmail();
            this.userForm.name = user.getName();
        }
        return "manage/editUser";
    }

    public boolean canAddUser() {
        return this.tracker.getUsers().size() < Configurator.getConfiguration().getLicenseKey().getUsersCount();
    }

    public Object storeUser() {
        if (this.tracker.getUsers().size() >= Configurator.getConfiguration().getLicenseKey().getUsersCount()) {
            return Pages.userList();
        }
        if (!this.userForm.validate(this.messages, this.tracker)) {
            return "manage/editUser";
        }
        if (this.userForm.editing) {
            User user = this.tracker.getUser(this.userForm.login);
            user.setName(this.userForm.name);
            if (!Strings.isBlank(this.userForm.password)) {
                user.setPassword(this.userForm.password);
            }
            user.setEmail(this.userForm.email);
            user.store();
        } else {
            this.tracker.createUser(this.userForm.login, this.userForm.password, this.userForm.email, this.userForm.name);
        }
        return Pages.userList();
    }

    public Object deleteUser() {
        this.tracker.deleteUser(this.userForm.login);
        return Pages.userList();
    }
}

