/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.manage;

import java.net.MalformedURLException;
import java.net.URL;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import lime.NamespacePath;
import ua.com.softway.tracker.SystemSettings;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.configuration.Configurator;
import ua.com.softway.tracker.ui.Messages;

@NamespacePath(value="/tracker/admin")
public class SystemSettingsAction {
    private final Tracker tracker;
    public String smtpHost;
    public String fromEmail;
    public String signature;
    public String publicUrl;
    public String smtpPassword;
    public String backupFolder;
    public String dataFolder;
    public Messages messages = new Messages();

    public SystemSettingsAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public String display() {
        SystemSettings settings = this.tracker.getSystemSettings();
        this.smtpHost = settings.getSmtpHost();
        this.fromEmail = settings.getFromEmail();
        this.signature = settings.getSignature();
        this.publicUrl = settings.getPublicUrl();
        this.smtpPassword = settings.getSmtpPassword();
        this.backupFolder = Configurator.getConfiguration().getBackupFolder();
        this.dataFolder = Configurator.getConfiguration().getDataFolder();
        return "manage/settings";
    }

    public Object save() {
        try {
            new URL(this.publicUrl);
        }
        catch (MalformedURLException e) {
            this.messages.addMessage("settings.invalidPublicUrl", new Object[0]);
        }
        try {
            new InternetAddress(this.fromEmail);
        }
        catch (AddressException e) {
            this.messages.addMessage("settings.invalidFromEmail", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return "manage/settings";
        }
        SystemSettings settings = this.tracker.getSystemSettings();
        settings.setFromEmail(this.fromEmail);
        settings.setPublicUrl(this.publicUrl);
        settings.setSignature(this.signature);
        settings.setSmtpHost(this.smtpHost);
        settings.setSmtpPassword(this.smtpPassword);
        settings.store();
        return Pages.projectList();
    }
}

