/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.manage;

import java.util.List;
import lime.NamespacePath;
import lime.outcome.Redirect;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.action.NoSuchUser;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.SelectOptions;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.ui.SelectOption;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker/admin")
public class ProjectAction {
    private final Tracker tracker;
    public String name;
    public String key;
    public String defaultAssignee;
    public Messages messages = new Messages();

    public ProjectAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public String projectList() {
        return "manage/projectList";
    }

    public String newProjectForm() {
        return "manage/newProject";
    }

    public String noProjects() {
        return "manage/noProjects";
    }

    public Object addProject() {
        if (this.key != null) {
            this.key = this.key.trim();
        }
        if (Strings.isBlank(this.key) || this.key.length() < 2) {
            this.messages.addMessage("project.error.key.length", new Object[0]);
        }
        if (!Strings.isLatinLetter(this.key) || !this.key.toUpperCase().equals(this.key)) {
            this.messages.addMessage("project.error.key.letters", new Object[0]);
        }
        if (this.tracker.getProject(this.key) != null) {
            this.messages.addMessage("project.error.key.duplicate", new Object[0]);
        }
        if (Strings.isBlank(this.name)) {
            this.messages.addMessage("project.error.name.empty", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return "manage/newProject";
        }
        this.tracker.createProject(this.key, this.name);
        return Pages.projectList();
    }

    public Redirect delete() {
        this.tracker.deleteProject(this.key);
        return Pages.projectList();
    }

    public String editProjectForm() {
        Project project = this.tracker.getProject(this.key);
        this.name = project.getName();
        this.defaultAssignee = project.getDefaultAssignee() != null ? project.getDefaultAssignee().getLogin() : "";
        return "manage/editProject";
    }

    public Object saveProject() {
        if (Strings.isBlank(this.name)) {
            this.messages.addMessage("project.error.name.empty", new Object[0]);
        }
        if (!SelectOption.NONE_OPTION.value.equals(this.defaultAssignee) && this.tracker.getUser(this.defaultAssignee) == null) {
            return new NoSuchUser(this.defaultAssignee);
        }
        if (!this.messages.isEmpty()) {
            return "manage/editProject";
        }
        Project project = this.tracker.getProject(this.key);
        project.setName(this.name);
        if (!SelectOption.NONE_OPTION.value.equals(this.defaultAssignee)) {
            project.setDefaultAssignee(this.tracker.getUser(this.defaultAssignee));
        } else {
            project.setDefaultAssignee(null);
        }
        project.store();
        return Pages.projectList();
    }

    public List<Project> getProjects() {
        return this.tracker.getProjects();
    }

    public List<SelectOption> getAssigneeOptions() {
        return SelectOptions.user(this.tracker.getProject(this.key).getPermissions().getAssignees(), true);
    }
}

