/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.manage;

import java.net.URL;
import lime.NamespacePath;
import lime.outcome.Redirect;
import ua.com.softway.tracker.JiraMigration;
import ua.com.softway.tracker.Migrator;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.util.Strings;

@NamespacePath(value="/tracker/admin")
public class MigrateAction {
    private final Migrator migrator;
    private final Tracker tracker;
    public String projectKey;
    public String jiraUrl;
    public String login;
    public String password;
    public Messages messages = new Messages();

    public MigrateAction(Tracker tracker, Migrator migrator) {
        this.tracker = tracker;
        this.migrator = migrator;
    }

    public String display() {
        return "manage/migration";
    }

    public Redirect cleanMigrationResults() {
        this.migrator.clean();
        return Pages.migration();
    }

    public Object migrateJira() {
        try {
            new URL(this.jiraUrl);
        }
        catch (Exception e) {
            this.messages.addMessage("migration.error.jiraUrl.invalid", new Object[0]);
        }
        if (Strings.isBlank(this.login)) {
            this.messages.addMessage("migration.error.login.empty", new Object[0]);
        }
        if (Strings.isBlank(this.login)) {
            this.messages.addMessage("migration.error.password.empty", new Object[0]);
        }
        if (Strings.isBlank(this.projectKey)) {
            this.messages.addMessage("migration.error.projectKey.empty", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return "manage/migration";
        }
        JiraMigration migration = new JiraMigration(this.jiraUrl, this.tracker, this.login, this.password, this.projectKey);
        this.migrator.startMigration(migration);
        return Pages.migration();
    }

    public boolean isMigrationCompleted() {
        return this.migrator.isMigrationCompleted();
    }

    public boolean isMigrationInProgress() {
        return this.migrator.isMigrationInProgress();
    }

    public boolean isCanStartMigration() {
        return this.migrator.canStartMigration();
    }

    public String getMigrationLog() {
        return this.migrator.getMigrationLog();
    }
}

