/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.manage;

import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lime.NamespacePath;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.SelectOptions;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.ui.SelectOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker/admin")
public class GroupUsersAction {
    private final Tracker tracker;
    public String key;
    public String login;
    public Messages messages = new Messages();

    public GroupUsersAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public Object list() {
        return "manage/groupUsers";
    }

    public Object remove() {
        this.tracker.getGroup(this.key).removeUser(this.login);
        this.tracker.getGroup(this.key).store();
        return Pages.editGroupUsers(this.key);
    }

    public Object add() {
        User user = this.tracker.getUser(this.login);
        if (user == null) {
            this.messages.addMessage("group.nosuchuser", new Object[0]);
            return this.list();
        }
        this.tracker.getGroup(this.key).addUser(user);
        this.tracker.getGroup(this.key).store();
        return Pages.editGroupUsers(this.key);
    }

    public SortedSet<User> getUsers() {
        Set<User> users = this.tracker.getGroup(this.key).getUsers();
        return new TreeSet<User>(users);
    }

    public List<SelectOption> getUsersToAddOptions() {
        List<User> users = this.tracker.getUsers();
        users.removeAll(this.tracker.getGroup(this.key).getUsers());
        return SelectOptions.user(users, false);
    }
}

