/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.manage;

import java.util.List;
import lime.NamespacePath;
import ua.com.softway.tracker.Group;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker/admin")
public class GroupAction {
    private final Tracker tracker;
    public Messages messages = new Messages();
    public String name;
    public String key;

    public GroupAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public Object list() {
        return "manage/groups";
    }

    public Object add() {
        if (!this.validateGroupName()) {
            return "manage/groups";
        }
        this.tracker.createGroup(this.name);
        return Pages.groups();
    }

    private boolean validateGroupName() {
        if (Strings.isBlank(this.name)) {
            this.messages.addMessage("group.name.empty", new Object[0]);
            return false;
        }
        if (this.tracker.getGroupWithName(this.name) != null) {
            this.messages.addMessage("group.name.duplicate", new Object[0]);
            return false;
        }
        return true;
    }

    public Object delete() {
        this.tracker.deleteGroup(this.key);
        return Pages.groups();
    }

    public Object setGroupName() {
        Group group = this.tracker.getGroup(this.key);
        if (!this.validateGroupName()) {
            return "manage/groups";
        }
        group.setName(this.name);
        group.store();
        return Pages.groups();
    }

    public List<Group> getGroups() {
        return this.tracker.getGroups();
    }
}

