/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.manage;

import java.util.Date;
import lime.NamespacePath;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.util.Strings;

@NamespacePath(value="/tracker")
public class EditVersionAction {
    private final Tracker tracker;
    public String projectKey;
    public String versionKey;
    public String name;
    public String plannedTo;
    public Messages messages = new Messages();

    public EditVersionAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public String versionForm() {
        Version version = this.tracker.getProject(this.projectKey).getVersion(this.versionKey);
        this.name = version.getName();
        this.plannedTo = User.currentUser().getDateFormat().formatDate(version.getPlannedTo());
        return "manage/editVersion";
    }

    public Object storeVersion() {
        if (Strings.isBlank(this.name)) {
            this.messages.addMessage("version.name.empty", new Object[0]);
        }
        if (!User.currentUser().getDateFormat().isValidDate(this.plannedTo)) {
            this.messages.addMessage("version.plannedDate.format", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return "manage/editVersion";
        }
        Date plannedToDate = User.currentUser().getDateFormat().parseDate(this.plannedTo);
        Project project = this.tracker.getProject(this.projectKey);
        Version version = project.getVersion(this.versionKey);
        if (version == null) {
            return Pages.versionList(this.projectKey);
        }
        version.setName(this.name);
        version.setPlannedTo(plannedToDate);
        project.store();
        return Pages.versionList(this.projectKey);
    }
}

