/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.i18n.Resources;
import ua.com.softway.tracker.worklog.WorkLogItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkLogItemView {
    private final WorkLogItem item;
    private final Issue issue;

    public WorkLogItemView(Issue issue, WorkLogItem item) {
        this.issue = issue;
        this.item = item;
    }

    public String getBegin() {
        return User.currentUser().getDateFormat().formatDate(this.item.getBegin());
    }

    public String getText() {
        if (this.item.getUser() != null) {
            return Resources.getText("issue.workLog.userSpent", this.item.getUser().getName(), this.item.getPeriod().toLocalString());
        }
        return Resources.getText("issue.workLog.spent", this.item.getPeriod().toLocalString());
    }

    public boolean canDelete() {
        return User.currentUser().equals(this.item.getUser());
    }

    public String getDeleteUrl() {
        return Pages.deleteWorkLogItem(this.issue.getKey(), this.item.getKey()).getPath();
    }

    public static List<WorkLogItemView> wrapWorkLog(Issue issue) {
        ArrayList<WorkLogItemView> result = new ArrayList<WorkLogItemView>();
        for (WorkLogItem item : issue.getWorkLog().getItems()) {
            result.add(new WorkLogItemView(issue, item));
        }
        return result;
    }
}

