/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import lime.NamespacePath;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.DateFormat;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Workflow;
import ua.com.softway.tracker.action.NoSuchIssue;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.issue.IssueView;
import ua.com.softway.tracker.events.IssueEvent;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.util.Strings;
import ua.com.softway.tracker.worklog.Period;
import ua.com.softway.tracker.worklog.WorkLogItem;

@NamespacePath(value="/tracker")
public class ViewIssueAction {
    private final Tracker tracker;
    public String issueKey;
    public String commentKey;
    public String comment;
    public Messages messages = new Messages();
    public String period;
    public String begin;
    public String workLogItemKey;

    public ViewIssueAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public Object display() {
        this.issueKey = this.issueKey.toUpperCase();
        if (this.tracker.getIssue(this.issueKey) == null) {
            return new NoSuchIssue(this.issueKey);
        }
        return "issue/viewIssue";
    }

    public IssueView getIssue() {
        return IssueView.wrap(this.tracker.getIssue(this.issueKey));
    }

    public boolean canDelete(Comment comment) {
        return User.currentUser().equals(comment.getAuthor());
    }

    public Object comment() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            new NoSuchIssue("issueKey");
        }
        if (Strings.isBlank(this.comment)) {
            this.messages.addMessage("issue.comment.text.required", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return "issue/viewIssue";
        }
        Comment c = new Comment(User.currentUser(), this.comment);
        issue.addComment(c);
        issue.store();
        this.tracker.addEvent(new IssueEvent(issue, "notification.commented", c));
        return Pages.viewIssue(this.issueKey);
    }

    public Object deleteComment() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        String commentText = issue.getComment(this.commentKey).getText();
        DateFormat dateFormat = User.currentUser().getDateFormat();
        String commentDate = dateFormat.formatDateTime(issue.getComment(this.commentKey).getPostedDate());
        issue.deleteComment(this.commentKey);
        issue.store();
        IssueEvent e = new IssueEvent(issue, "notification.deleteComment");
        e.setDetails(commentText + " ( " + commentDate + " )");
        this.tracker.addEvent(e);
        return Pages.viewIssue(this.issueKey);
    }

    public Object stop() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        Workflow workflow = issue.getProject().getWorkflow();
        workflow.stop(issue);
        this.tracker.addEvent(new IssueEvent(issue, "notification.stopped"));
        return Pages.viewIssue(this.issueKey);
    }

    public Object start() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        issue.setAssignee(User.currentUser());
        this.tracker.addEvent(new IssueEvent(issue, "notification.assigned"));
        Workflow workflow = issue.getProject().getWorkflow();
        workflow.start(issue);
        this.tracker.addEvent(new IssueEvent(issue, "notification.started"));
        return Pages.viewIssue(this.issueKey);
    }

    public Object assignToMe() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        issue.setAssignee(User.currentUser());
        issue.store();
        this.tracker.addEvent(new IssueEvent(issue, "notification.assigned"));
        return Pages.viewIssue(this.issueKey);
    }

    public Object watch() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        issue.getWatchers().add(User.currentUser());
        issue.store();
        return Pages.viewIssue(this.issueKey);
    }

    public Object stopWatch() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        issue.getWatchers().remove(User.currentUser());
        issue.store();
        return Pages.viewIssue(this.issueKey);
    }

    public Object logWork() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        if (!User.currentUser().getDateFormat().isValidDate(this.begin)) {
            this.messages.addMessage("issue.workLog.begin.format", new Object[0]);
        }
        if (Strings.isBlank(this.period) || Period.fromLocalString(this.period) == null) {
            this.messages.addMessage("issue.workLog.period.format", new Object[0]);
        }
        if (!this.messages.isEmpty()) {
            return this.display();
        }
        WorkLogItem item = new WorkLogItem();
        item.setBegin(User.currentUser().getDateFormat().parseDate(this.begin));
        item.setPeriod(Period.fromLocalString(this.period));
        item.setUser(User.currentUser());
        issue.getWorkLog().add(item);
        issue.store();
        return Pages.viewIssue(this.issueKey);
    }

    public Object deleteWorkLog() {
        Issue issue = this.tracker.getIssue(this.issueKey);
        if (issue == null) {
            return new NoSuchIssue(this.issueKey);
        }
        issue.getWorkLog().remove(this.workLogItemKey);
        issue.store();
        return Pages.viewIssue(this.issueKey);
    }
}

