/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import lime.download.Download;
import ua.com.softway.tracker.DateFormat;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.issuebrowser.action.IssueBrowser;
import ua.com.softway.tracker.velocity.VelocityTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuesExcelDownload
implements Download {
    private byte[] data;

    public IssuesExcelDownload(List<Issue> issues, List<IssueField> fields) {
        StringWriter stringWriter = new StringWriter();
        VelocityTemplate template = new VelocityTemplate("issue/exportToExcel.vm");
        template.put("browser", new IssueBrowser(issues, fields));
        DateFormat dateFormat = User.currentUser().getDateFormat();
        template.put("date", dateFormat.formatDate(new Date()));
        template.put("time", dateFormat.formatTime(new Date()));
        template.render(stringWriter);
        try {
            this.data = stringWriter.getBuffer().toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    @Override
    public String getContentType() {
        return "application/vnd.ms-excel; charset=UTF-8";
    }

    @Override
    public String getFileName() {
        return "issues.html";
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public int getSize() {
        return this.data.length;
    }
}

