/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueAttachment;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.issue.CommentView;
import ua.com.softway.tracker.action.issue.IssueEventView;
import ua.com.softway.tracker.action.issue.IssueTextRenderer;
import ua.com.softway.tracker.action.issue.Operation;
import ua.com.softway.tracker.action.issue.WorkLogItemView;
import ua.com.softway.tracker.action.issue.operation.AssignIssueOperation;
import ua.com.softway.tracker.action.issue.operation.AssignToMeOperation;
import ua.com.softway.tracker.action.issue.operation.AttachToIssueOperation;
import ua.com.softway.tracker.action.issue.operation.CloseIssueOperation;
import ua.com.softway.tracker.action.issue.operation.DeleteIssueOperation;
import ua.com.softway.tracker.action.issue.operation.EditIssueOperation;
import ua.com.softway.tracker.action.issue.operation.ReopenIssueOperation;
import ua.com.softway.tracker.action.issue.operation.ResolveIssueOperation;
import ua.com.softway.tracker.action.issue.operation.StartIssueOperation;
import ua.com.softway.tracker.action.issue.operation.StopIssueOperation;
import ua.com.softway.tracker.action.issue.operation.StopWatchOperation;
import ua.com.softway.tracker.action.issue.operation.WatchOperation;
import ua.com.softway.tracker.events.IssueEvent;
import ua.com.softway.tracker.text.TextRenderer;
import ua.com.softway.tracker.util.Strings;
import ua.com.softway.tracker.util.XmlEscaper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueView {
    private Issue issue;
    private TextRenderer renderer;

    private IssueView(Issue issue) {
        this.issue = issue;
        this.renderer = new IssueTextRenderer();
    }

    public String getKey() {
        return this.issue.getKey();
    }

    public String getSummary() {
        return XmlEscaper.escape(this.issue.getSummary());
    }

    public String getDescription() {
        if (Strings.isBlank(this.issue.getDescription())) {
            return "";
        }
        return this.renderer.render(this.issue.getDescription());
    }

    public String getStatus() {
        return IssueField.STATUS.getHtmlValue(this.issue);
    }

    public String getPriority() {
        return IssueField.PRIORITY.getHtmlValue(this.issue);
    }

    public String getType() {
        return IssueField.TYPE.getHtmlValue(this.issue);
    }

    public boolean displayResolution() {
        return this.issue.getResolution() != null;
    }

    public boolean displayEstimate() {
        return this.issue.getEstimate() != null && !Strings.isBlank(this.issue.getEstimate().toString());
    }

    public String getResolution() {
        return this.issue.getResolution().getName();
    }

    public String getEstimate() {
        return this.issue.getEstimate().toString();
    }

    public String getAffects() {
        return IssueField.AFFECTS.getHtmlValue(this.issue);
    }

    public String getFix() {
        return IssueField.FIX.getHtmlValue(this.issue);
    }

    public String getComponent() {
        return IssueField.COMPONENT.getHtmlValue(this.issue);
    }

    public String getAssignee() {
        return IssueField.ASSIGNEE.getHtmlValue(this.issue);
    }

    public String getReporter() {
        return IssueField.REPORTER.getHtmlValue(this.issue);
    }

    public String getCreated() {
        return IssueField.CREATED.getValue(this.issue);
    }

    public String getUpdated() {
        return IssueField.UPDATED.getValue(this.issue);
    }

    public List<Operation> getWorkflowOperations() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add(new StartIssueOperation(this.issue));
        operations.add(new StopIssueOperation(this.issue));
        operations.add(new ResolveIssueOperation(this.issue));
        operations.add(new CloseIssueOperation(this.issue));
        operations.add(new ReopenIssueOperation(this.issue));
        return operations;
    }

    public List<Operation> getOtherOperations() {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        if (this.issue.getWatchers().contains(User.currentUser())) {
            operations.add(new StopWatchOperation(this.issue));
        } else {
            operations.add(new WatchOperation(this.issue));
        }
        operations.add(new EditIssueOperation(this.issue));
        operations.add(new AttachToIssueOperation(this.issue));
        operations.add(new AssignToMeOperation(this.issue));
        operations.add(new AssignIssueOperation(this.issue));
        return operations;
    }

    public Operation getDeleteOperation() {
        return new DeleteIssueOperation(this.issue);
    }

    public List<CommentView> getComments() {
        return CommentView.wrap(this.issue.getComments(), this.renderer);
    }

    public List<WorkLogItemView> getWorkLog() {
        return WorkLogItemView.wrapWorkLog(this.issue);
    }

    public List<IssueEventView> getEvents() {
        List<IssueEvent> events = Tracker.instance().getEventRecorder().getEvents(this.issue);
        ArrayList<IssueEventView> result = new ArrayList<IssueEventView>();
        for (IssueEvent event : events) {
            result.add(new IssueEventView(event));
        }
        return result;
    }

    public List<IssueAttachment> getAttachments() {
        return this.issue.getAttachments();
    }

    public static IssueView wrap(Issue issue) {
        return new IssueView(issue);
    }

    public static List<IssueView> wrap(List<Issue> issues) {
        ArrayList<IssueView> result = new ArrayList<IssueView>();
        for (Issue issue : issues) {
            result.add(new IssueView(issue));
        }
        return result;
    }
}

