/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.util.ArrayList;
import java.util.List;
import lime.outcome.Redirect;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.issue.IssueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuePaging
implements IssueSource {
    private int pageSize;
    private IssueSource issueSource;
    private int pageStart;

    public IssuePaging(int pageSize, IssueSource issueSource) {
        this.pageSize = pageSize;
        this.issueSource = issueSource;
    }

    @Override
    public List<Issue> getIssues() {
        List<Issue> issues = this.issueSource.getIssues();
        return issues.subList(this.getPageStart(), Math.min(this.getPageStart() + this.pageSize, issues.size()));
    }

    public int getNextPageStart() {
        return this.getPageStart() + this.pageSize;
    }

    public void setPageStart(int pageStart) {
        this.pageStart = pageStart;
    }

    public int getPageStart() {
        if (this.pageStart >= this.issueSource.getIssues().size() || this.pageStart < 0) {
            this.pageStart = 0;
        }
        return this.pageStart;
    }

    public boolean hasNextPage() {
        return this.getNextPageStart() < this.issueSource.getIssues().size();
    }

    public List<Page> getPages() {
        ArrayList<Page> result = new ArrayList<Page>();
        for (int i = 0; i < this.issueSource.getIssues().size(); i += this.pageSize) {
            result.add(new Page(i));
        }
        return result;
    }

    public class Page {
        private int start;

        public Page(int start) {
            this.start = start;
        }

        public String getLabel() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.start + 1);
            sb.append(" .. ");
            sb.append(Math.min(this.start + IssuePaging.this.pageSize, IssuePaging.this.issueSource.getIssues().size()));
            return sb.toString();
        }

        public Redirect getUrl() {
            return Pages.browseIssues(this.start);
        }

        public boolean isCurrent() {
            return IssuePaging.this.getPageStart() == this.start;
        }
    }
}

