/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Component;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.IssueType;
import ua.com.softway.tracker.Priority;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Resolution;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.action.SelectOptions;
import ua.com.softway.tracker.events.UpdatedField;
import ua.com.softway.tracker.i18n.Resources;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.ui.SelectOption;
import ua.com.softway.tracker.util.Objects;
import ua.com.softway.tracker.util.Strings;
import ua.com.softway.tracker.worklog.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueForm {
    public static final String AUTOMATIC_ASSIGNEE = "automatic-assignee";
    public String projectKey = "";
    public String key = "";
    public String summary = "";
    public String description = "";
    public String reporter = "";
    public String assignee = "";
    public String fix = "";
    public String affects = "";
    public String issueType = "";
    public String priority = "";
    public String resolution = "";
    public String component = "";
    public String estimate = "";
    private final Tracker tracker;

    public IssueForm(Tracker tracker) {
        this.tracker = tracker;
    }

    void selectProject(Project project) {
        this.projectKey = project != null ? project.getKey() : SelectOption.NONE_OPTION.value;
    }

    public boolean isEditing() {
        return !Strings.isBlank(this.key);
    }

    public Project getProject() {
        return this.tracker.getProject(this.projectKey);
    }

    public List<SelectOption> getVersionOptions() {
        return SelectOptions.version(this.getProject().getVersions(), true);
    }

    public List<SelectOption> getComponentOptions() {
        return SelectOptions.components(this.getProject().getComponents(), true);
    }

    public List<SelectOption> getPriorityOptions() {
        return SelectOptions.priority();
    }

    public List<SelectOption> getIssueTypeOptions() {
        return SelectOptions.issueType();
    }

    public List<SelectOption> getProjectOptions() {
        return SelectOptions.project(this.tracker.getVisibleProjects(), false);
    }

    public List<SelectOption> getResolutionOptions() {
        return SelectOptions.resolution(this.getProject().getResolutions());
    }

    public List<SelectOption> getReporterOptions() {
        return SelectOptions.user(this.tracker.getUsers(), true);
    }

    public List<SelectOption> getAssigneeOptions() {
        List<SelectOption> result = SelectOptions.user(this.getProject().getPermissions().getAssignees(), true);
        result.add(0, new SelectOption(AUTOMATIC_ASSIGNEE, Resources.getText("issueEditor.assign.automatically")));
        return result;
    }

    public boolean valid(Messages messages) {
        if (Strings.isBlank(this.summary)) {
            messages.addMessage("issueAction.error.empty.summary", new Object[0]);
        }
        if (!SelectOption.NONE_OPTION.value.equals(this.reporter) && this.tracker.getUser(this.reporter) == null) {
            messages.addMessage("issueAction.error.no.such.reporter", new Object[0]);
        }
        if (!AUTOMATIC_ASSIGNEE.equals(this.assignee) && !SelectOption.NONE_OPTION.value.equals(this.assignee) && this.tracker.getUser(this.assignee) == null) {
            messages.addMessage("issueAction.error.no.such.assignee", new Object[0]);
        }
        if (!SelectOption.NONE_OPTION.value.equals(this.affects) && this.getProject().getVersion(this.affects) == null) {
            messages.addMessage("issueAction.error.no.such.affects", new Object[0]);
        }
        if (!SelectOption.NONE_OPTION.value.equals(this.fix) && this.getProject().getVersion(this.fix) == null) {
            messages.addMessage("issueAction.error.no.such.fix", new Object[0]);
        }
        if (!SelectOption.NONE_OPTION.value.equals(this.component) && this.getProject().getComponent(this.component) == null) {
            messages.addMessage("issueAction.error.no.such.component", new Object[0]);
        }
        if (!Strings.isBlank(this.estimate) && Period.fromLocalString(this.estimate) == null) {
            messages.addMessage("issueAction.error.invalidEstimate", new Object[0]);
        }
        return messages.isEmpty();
    }

    public User getReporter() {
        if (SelectOption.NONE_OPTION.value.equals(this.reporter)) {
            return null;
        }
        return this.tracker.getUser(this.reporter);
    }

    public User getAssignee() {
        if (SelectOption.NONE_OPTION.value.equals(this.assignee)) {
            return null;
        }
        if (AUTOMATIC_ASSIGNEE.equals(this.assignee)) {
            if (this.getComponent() != null && this.getComponent().getLead() != null) {
                return this.getComponent().getLead();
            }
            if (this.getProject() != null && this.getProject().getDefaultAssignee() != null) {
                return this.getProject().getDefaultAssignee();
            }
            return null;
        }
        return this.tracker.getUser(this.assignee);
    }

    public Component getComponent() {
        if (SelectOption.NONE_OPTION.value.equals(this.component)) {
            return null;
        }
        return this.getProject().getComponent(this.component);
    }

    public Version getFixVersion() {
        if (SelectOption.NONE_OPTION.value.equals(this.fix)) {
            return null;
        }
        return this.getProject().getVersion(this.fix);
    }

    public Version getAffectsVersion() {
        if (SelectOption.NONE_OPTION.value.equals(this.affects)) {
            return null;
        }
        return this.getProject().getVersion(this.affects);
    }

    public Period getEstimate() {
        if (!Strings.isBlank(this.estimate)) {
            return Period.fromLocalString(this.estimate);
        }
        return null;
    }

    public List<UpdatedField> getUpdatedFields(Issue issue) {
        ArrayList<UpdatedField> updatedFields = new ArrayList<UpdatedField>();
        if (!issue.getSummary().equals(this.summary)) {
            updatedFields.add(new UpdatedField("summary", issue.getSummary(), this.summary));
        }
        if (!Objects.equals(issue.getDescription(), this.description)) {
            updatedFields.add(new UpdatedField("description", issue.getDescription(), this.description));
        }
        if (!Objects.equals(issue.getAssignee(), this.getAssignee())) {
            updatedFields.add(new UpdatedField("assignee", issue.getAssignee() != null ? issue.getAssignee().getName() : null, this.getAssignee() != null ? this.getAssignee().getName() : null));
        }
        if (!Objects.equals(issue.getReporter(), this.getReporter())) {
            updatedFields.add(new UpdatedField("reporter", issue.getReporter() != null ? issue.getReporter().getName() : null, this.getReporter() != null ? this.getReporter().getName() : null));
        }
        if (!Objects.equals(issue.getAffects(), this.getAffectsVersion())) {
            updatedFields.add(new UpdatedField("affects", issue.getAffects() != null ? issue.getAffects().getName() : null, this.getAffectsVersion() != null ? this.getAffectsVersion().getName() : null));
        }
        if (!Objects.equals(issue.getFix(), this.getFixVersion())) {
            updatedFields.add(new UpdatedField("fix", issue.getFix() != null ? issue.getFix().getName() : null, this.getFixVersion() != null ? this.getFixVersion().getName() : null));
        }
        if (!Objects.equals(issue.getResolution(), this.getResolution())) {
            updatedFields.add(new UpdatedField("resolution", issue.getResolution() != null ? issue.getResolution().getName() : null, this.getResolution() != null ? this.getResolution().getName() : null));
        }
        if (!Objects.equals(issue.getPriority(), this.getPriority())) {
            updatedFields.add(new UpdatedField("priority", issue.getPriority().localizedName(), this.getPriority().localizedName()));
        }
        if (!Objects.equals(issue.getType(), this.getIssueType())) {
            updatedFields.add(new UpdatedField("type", issue.getType().localizedName(), this.getIssueType().localizedName()));
        }
        if (!Objects.equals(issue.getEstimate(), this.getEstimate())) {
            updatedFields.add(new UpdatedField("estimate", issue.getEstimate() == null ? null : issue.getEstimate().toLocalString(), this.getEstimate() == null ? null : this.getEstimate().toLocalString()));
        }
        return updatedFields;
    }

    public Priority getPriority() {
        return Priority.valueOf(this.priority);
    }

    public IssueType getIssueType() {
        return IssueType.valueOf(this.issueType);
    }

    public Resolution getResolution() {
        if (this.canEditResolution()) {
            return this.getProject().getResolution(Integer.parseInt(this.resolution));
        }
        return null;
    }

    public void newIssue(Project project, User reporter) {
        this.selectProject(project);
        this.reporter = reporter.getLogin();
        this.assignee = AUTOMATIC_ASSIGNEE;
        this.affects = SelectOption.NONE_OPTION.value;
        this.fix = SelectOption.NONE_OPTION.value;
        this.component = SelectOption.NONE_OPTION.value;
        this.issueType = project.getDefaultIssueType().name();
        this.priority = project.getDefaultPriority().name();
    }

    public void editIssue(Issue issue) {
        this.key = issue.getKey();
        this.selectProject(issue.getProject());
        this.summary = issue.getSummary();
        this.description = issue.getDescription();
        User assignee = issue.getAssignee();
        this.assignee = assignee != null ? assignee.getLogin() : SelectOption.NONE_OPTION.value;
        User reporter = issue.getReporter();
        this.reporter = reporter != null ? reporter.getLogin() : SelectOption.NONE_OPTION.value;
        Version affects = issue.getAffects();
        this.affects = affects != null ? affects.getKey() : SelectOption.NONE_OPTION.value;
        Version fix = issue.getFix();
        this.fix = fix != null ? fix.getKey() : SelectOption.NONE_OPTION.value;
        this.component = issue.getComponent() != null ? issue.getComponent().getKey() : SelectOption.NONE_OPTION.value;
        if (issue.getStatus().equals(IssueStatus.RESOLVED) || issue.getStatus().equals(IssueStatus.CLOSED)) {
            this.resolution = issue.getResolution() != null ? "" + issue.getResolution().getCode() : "" + issue.getProject().getDefaultResolution().getCode();
        }
        this.issueType = issue.getType().name();
        this.priority = issue.getPriority().name();
        if (issue.getEstimate() != null) {
            this.estimate = issue.getEstimate().toLocalString();
        }
    }

    public boolean canEditResolution() {
        return !"".equals(this.resolution);
    }
}

