/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Component;
import ua.com.softway.tracker.Direction;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.IssueFilter;
import ua.com.softway.tracker.IssueMatcher;
import ua.com.softway.tracker.IssueStatus;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Version;
import ua.com.softway.tracker.action.SelectOptions;
import ua.com.softway.tracker.action.issue.CurrentProject;
import ua.com.softway.tracker.action.issue.IssueSorter;
import ua.com.softway.tracker.action.issue.IssueSource;
import ua.com.softway.tracker.i18n.Resources;
import ua.com.softway.tracker.ui.SelectOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueFilterForm
implements CurrentProject,
IssueSource {
    private Tracker tracker;
    public String visible = "false";
    public IssueField comparator = IssueField.KEY;
    public Direction direction = Direction.ASC;
    public String key;
    public String name;
    public String project;
    public String text;
    public String affects;
    public String fix;
    public String reporter;
    public String assignee;
    public String status;
    public String priority;
    public String issueType;
    public String component;

    public IssueFilterForm(Tracker tracker) {
        this.tracker = tracker;
        this.reset();
    }

    private IssueMatcher getMatcher() {
        IssueMatcher matcher = new IssueMatcher(this.tracker, this.project);
        matcher.setReporter(this.reporter);
        matcher.setAssignee(this.assignee);
        matcher.setAffects(this.affects);
        matcher.setFix(this.fix);
        matcher.setStatus(this.status);
        matcher.setPriority(this.priority);
        matcher.setIssueType(this.issueType);
        matcher.setComponent(this.component);
        matcher.setText(this.text);
        return matcher;
    }

    @Override
    public List<Issue> getIssues() {
        List<Issue> matchedIssues = this.getMatcher().getMatchedIssues();
        return new IssueSorter(this.comparator, this.direction).sort(matchedIssues);
    }

    public List<SelectOption> getVersionOptions() {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        options.add(new SelectOption("*", Resources.getText("browseIssues.filter.any")));
        options.add(new SelectOption("-", Resources.getText("browseIssues.filter.none")));
        for (Version version : this.getCurrentProject().getVersions()) {
            options.add(new SelectOption(version.getKey(), version.getName()));
        }
        return options;
    }

    public List<SelectOption> getUserOptions() {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        options.add(new SelectOption("*", Resources.getText("browseIssues.filter.any")));
        options.add(new SelectOption("-", Resources.getText("browseIssues.filter.none")));
        for (User user : this.tracker.getUsers()) {
            options.add(new SelectOption(user.getLogin(), user.getName()));
        }
        return options;
    }

    public List<SelectOption> getStatusOptions() {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        options.add(new SelectOption("*", Resources.getText("browseIssues.filter.any")));
        options.add(new SelectOption(IssueMatcher.statusExpression(IssueStatus.openStatuses()), Resources.getText("browseIssues.filter.all.open")));
        String allResolved = IssueStatus.RESOLVED.getCode() + "," + IssueStatus.CLOSED.getCode();
        options.add(new SelectOption(allResolved, Resources.getText("browseIssues.filter.all.resolved")));
        class IssueStatusOption
        extends SelectOption {
            public IssueStatusOption(IssueStatus issueStatus) {
                super(issueStatus.getCode(), issueStatus.localizedName());
            }
        }
        options.add(new IssueStatusOption(IssueStatus.OPEN));
        options.add(new IssueStatusOption(IssueStatus.IN_PROGRESS));
        options.add(new IssueStatusOption(IssueStatus.REOPENED));
        options.add(new IssueStatusOption(IssueStatus.RESOLVED));
        options.add(new IssueStatusOption(IssueStatus.CLOSED));
        return options;
    }

    public List<SelectOption> getPriorityOptions() {
        List<SelectOption> priorities = SelectOptions.priority();
        priorities.add(0, new SelectOption("*", Resources.getText("browseIssues.filter.any")));
        return priorities;
    }

    public List<SelectOption> getIssueTypeOptions() {
        List<SelectOption> issueTypes = SelectOptions.issueType();
        issueTypes.add(0, new SelectOption("*", Resources.getText("browseIssues.filter.any")));
        return issueTypes;
    }

    public List<SelectOption> getComponentOptions() {
        ArrayList<SelectOption> selectOptions = new ArrayList<SelectOption>();
        selectOptions.add(new SelectOption("*", Resources.getText("browseIssues.filter.any")));
        selectOptions.add(new SelectOption("-", Resources.getText("browseIssues.filter.none")));
        for (Component c : this.getCurrentProject().getComponents()) {
            selectOptions.add(new SelectOption(c.getKey(), c.getName()));
        }
        return selectOptions;
    }

    public void useFilter(IssueFilter filter) {
        this.key = filter.getKey();
        this.name = filter.getName();
        this.project = filter.getProject();
        this.reporter = filter.getReporter();
        this.assignee = filter.getAffects();
        this.affects = filter.getAffects();
        this.fix = filter.getFix();
        this.status = filter.getStatus();
        this.priority = filter.getPriority();
        this.issueType = filter.getIssueType();
        this.component = filter.getComponent();
        this.text = filter.getText();
        this.comparator = filter.getComparator();
        this.direction = filter.getDirection();
    }

    public void reset() {
        this.key = "";
        this.name = "";
        this.text = "";
        this.affects = "*";
        this.fix = "*";
        this.reporter = "*";
        this.assignee = "*";
        this.status = "*";
        this.priority = "*";
        this.issueType = "*";
        this.component = "*";
        this.comparator = IssueField.KEY;
        this.direction = Direction.ASC;
    }

    @Override
    public Project getCurrentProject() {
        if (this.tracker.getProject(this.project) == null && this.tracker.getVisibleProjects().size() > 0) {
            this.setCurrentProject(this.tracker.getVisibleProjects().get(0));
        }
        return this.tracker.getProject(this.project);
    }

    @Override
    public void setCurrentProject(Project project) {
        this.reset();
        this.project = project.getKey();
    }
}

