/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import lime.NamespacePath;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.NoSuchProject;
import ua.com.softway.tracker.Project;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.NoSuchIssue;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.issue.CurrentProject;
import ua.com.softway.tracker.action.issue.IssueForm;
import ua.com.softway.tracker.events.IssueEvent;
import ua.com.softway.tracker.ui.Message;
import ua.com.softway.tracker.ui.Messages;
import ua.com.softway.tracker.util.Strings;

@NamespacePath(value="/tracker")
public class IssueAction {
    private Tracker tracker;
    private CurrentProject currentProject;
    public IssueForm issueForm;
    public Messages messages = new Messages();
    public String comment = "";

    public IssueAction(Tracker tracker, CurrentProject currentProject) {
        this.tracker = tracker;
        this.currentProject = currentProject;
        this.issueForm = new IssueForm(tracker);
    }

    public Object editIssue() {
        Issue issue = this.tracker.getIssue(this.issueForm.key);
        if (issue == null) {
            return new NoSuchIssue(this.issueForm.key);
        }
        this.issueForm.editIssue(issue);
        return "issue/issueEditor";
    }

    public Object newIssue() {
        if (this.tracker.getVisibleProjects().size() == 0) {
            return new Message("issueAction.no.projects", new Object[0]);
        }
        Project project = this.currentProject.getCurrentProject();
        if (!project.getPermissions().canCreateIssue()) {
            return new Message("issueAction.no.permission.to.create", new Object[0]);
        }
        this.issueForm.newIssue(project, User.currentUser());
        return "issue/issueEditor";
    }

    public boolean canAssign() {
        return this.tracker.getProject(this.issueForm.projectKey).getPermissions().canAssignIssue();
    }

    public Object form() {
        Project project = this.tracker.getProject(this.issueForm.projectKey);
        if (project == null) {
            return new NoSuchProject(this.issueForm.projectKey);
        }
        return "issue/issueEditor";
    }

    public Object store() {
        if (!this.issueForm.valid(this.messages)) {
            return "issue/issueEditor";
        }
        if (this.issueForm.isEditing()) {
            Issue issue = this.tracker.getIssue(this.issueForm.key);
            IssueEvent event = new IssueEvent();
            event.setIssue(issue);
            event.setAction("notification.updated");
            event.setUpdatedFields(this.issueForm.getUpdatedFields(issue));
            if (!Strings.isBlank(this.comment)) {
                Comment c = new Comment(User.currentUser(), this.comment);
                issue.addComment(c);
                event.setComment(c);
            }
            issue.setSummary(this.issueForm.summary);
            issue.setDescription(this.issueForm.description);
            issue.setAssignee(this.issueForm.getAssignee());
            issue.setReporter(this.issueForm.getReporter());
            issue.setAffectsVersion(this.issueForm.getAffectsVersion());
            issue.setFixVersion(this.issueForm.getFixVersion());
            issue.setType(this.issueForm.getIssueType());
            issue.setPriority(this.issueForm.getPriority());
            issue.setResolution(this.issueForm.getResolution());
            issue.setComponent(this.issueForm.getComponent());
            issue.setEstimate(this.issueForm.getEstimate());
            issue.store();
            this.tracker.addEvent(event);
            return Pages.viewIssue(issue.getKey());
        }
        Project project = this.issueForm.getProject();
        User assignee = this.issueForm.getAssignee();
        Issue issue = project.createIssue(this.issueForm.summary, this.issueForm.description, this.issueForm.getReporter(), assignee, this.issueForm.getAffectsVersion(), this.issueForm.getFixVersion(), this.issueForm.getIssueType(), this.issueForm.getPriority(), null);
        issue.setComponent(this.issueForm.getComponent());
        issue.setEstimate(this.issueForm.getEstimate());
        issue.store();
        IssueEvent event = new IssueEvent();
        event.setIssue(issue);
        event.setAction("notification.created");
        event.setDetails(issue.getSummary());
        this.tracker.addEvent(event);
        return Pages.viewIssue(issue.getKey());
    }
}

