/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import ua.com.softway.tracker.Direction;
import ua.com.softway.tracker.IssueField;
import ua.com.softway.tracker.action.BrowseIssuesUrl;

public class HeaderSorting {
    private IssueField issueField;
    private IssueField comparator;
    private Direction direction;

    public HeaderSorting(IssueField issueField, IssueField comparator, Direction direction) {
        if (issueField == null) {
            throw new IllegalArgumentException("issueField is null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("comparator is null");
        }
        if (direction == null) {
            throw new IllegalArgumentException("direction is null");
        }
        this.comparator = comparator;
        this.direction = direction;
        this.issueField = issueField;
    }

    public boolean isCurrent() {
        return this.comparator.equals(this.issueField);
    }

    public String getSortingIcon() {
        if (this.isCurrent()) {
            return "/img/sort_" + this.direction.name().toLowerCase() + ".gif";
        }
        return null;
    }

    public String getSortingUrl() {
        BrowseIssuesUrl url = new BrowseIssuesUrl(false);
        url.setIssueComparator(this.issueField);
        url.setIssueDirection(this.isCurrent() ? this.direction.invert() : Direction.ASC);
        url.setPageStart(0);
        return url.getPath();
    }
}

