/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.util.ArrayList;
import java.util.List;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.text.TextRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentView {
    private Comment comment;
    private TextRenderer renderer;

    public CommentView(Comment comment, TextRenderer renderer) {
        this.renderer = renderer;
        this.comment = comment;
    }

    public String getHeader() {
        String header = "";
        header = this.comment.getAuthor() != null ? header + this.comment.getAuthor().getName() : header + "Unknown";
        header = header + "&nbsp;&nbsp;&nbsp;&nbsp;";
        header = header + User.currentUser().getDateFormat().formatDateTime(this.comment.getPostedDate());
        header = header + "&nbsp;&nbsp;&nbsp;&nbsp;";
        return header;
    }

    public String getText() {
        return this.renderer.render(this.comment.getText());
    }

    public String getKey() {
        return this.comment.getKey();
    }

    public static CommentView wrap(Comment comment, TextRenderer render) {
        return new CommentView(comment, render);
    }

    public static List<CommentView> wrap(List<Comment> comments, TextRenderer renderer) {
        ArrayList<CommentView> result = new ArrayList<CommentView>();
        for (Comment comment : comments) {
            result.add(CommentView.wrap(comment, renderer));
        }
        return result;
    }
}

