/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.util.List;
import lime.NamespacePath;
import ua.com.softway.tracker.Comment;
import ua.com.softway.tracker.Issue;
import ua.com.softway.tracker.Tracker;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.Workflow;
import ua.com.softway.tracker.action.Pages;
import ua.com.softway.tracker.action.SelectOptions;
import ua.com.softway.tracker.events.IssueEvent;
import ua.com.softway.tracker.ui.Message;
import ua.com.softway.tracker.ui.SelectOption;
import ua.com.softway.tracker.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class CloseIssueAction {
    private final Tracker tracker;
    public String issueKey;
    public String resolution;
    public String assignee;
    public String comment;

    public CloseIssueAction(Tracker tracker) {
        this.tracker = tracker;
    }

    public String display() {
        Issue issue = this.getIssue();
        this.resolution = issue.getResolution() == null ? issue.getProject().getDefaultResolution().getName() : "" + issue.getResolution().getCode();
        this.assignee = issue.getAssignee() != null ? issue.getAssignee().getLogin() : SelectOption.NONE_OPTION.value;
        return "issue/closeIssue";
    }

    public Issue getIssue() {
        return this.tracker.getIssue(this.issueKey);
    }

    public List<SelectOption> getResolutionOptions() {
        return SelectOptions.resolution(this.getIssue().getProject().getResolutions());
    }

    public List<SelectOption> getAssigneeOptions() {
        return SelectOptions.user(this.tracker.getUsers(), true);
    }

    public Object process() {
        Issue issue = this.getIssue();
        if (!issue.getProject().getPermissions().canCloseIssue()) {
            return new Message("no.permissions", new Object[0]);
        }
        issue.setAssignee(this.tracker.getUser(this.assignee));
        issue.setResolution(issue.getProject().getResolution(Integer.parseInt(this.resolution)));
        Comment c = null;
        if (!Strings.isBlank(this.comment)) {
            c = new Comment(User.currentUser(), this.comment);
            issue.addComment(c);
        }
        Workflow workflow = issue.getProject().getWorkflow();
        workflow.close(issue);
        issue.store();
        this.tracker.addEvent(new IssueEvent(issue, "notification.closed", c));
        return Pages.viewIssue(this.issueKey);
    }
}

