/*
 * Decompiled with CFR 0.152.
 */
package ua.com.softway.tracker.action.issue;

import java.util.List;
import lime.NamespacePath;
import lime.download.Download;
import ua.com.softway.tracker.IssueFilter;
import ua.com.softway.tracker.User;
import ua.com.softway.tracker.action.issue.HeaderSorting;
import ua.com.softway.tracker.action.issue.IssueFilterForm;
import ua.com.softway.tracker.action.issue.IssuePaging;
import ua.com.softway.tracker.action.issue.IssueView;
import ua.com.softway.tracker.action.issue.IssuesExcelDownload;
import ua.com.softway.tracker.issuebrowser.IssueBrowserConfiguration;
import ua.com.softway.tracker.issuebrowser.action.IssueBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NamespacePath(value="/tracker")
public class BrowseIssuesAction {
    public final IssueFilterForm filter;
    public final IssuePaging paging;

    public BrowseIssuesAction(IssueFilterForm filter, IssuePaging issuePaging) {
        this.filter = filter;
        this.paging = issuePaging;
    }

    public List<IssueView> getIssues() {
        return IssueView.wrap(this.paging.getIssues());
    }

    public String saveFilter() {
        User user = User.currentUser();
        IssueFilter issueFilter = user.getIssueFilter(this.filter.key);
        if (issueFilter == null) {
            issueFilter = new IssueFilter(this.filter.project);
            user.addCustomFilter(issueFilter);
        }
        this.filter.key = issueFilter.getKey();
        issueFilter.setName(this.filter.name);
        issueFilter.setAssignee(this.filter.assignee);
        issueFilter.setReporter(this.filter.reporter);
        issueFilter.setAffects(this.filter.affects);
        issueFilter.setFix(this.filter.fix);
        issueFilter.setStatus(this.filter.status);
        issueFilter.setPriority(this.filter.priority);
        issueFilter.setIssueType(this.filter.issueType);
        issueFilter.setComponent(this.filter.component);
        issueFilter.setText(this.filter.text);
        issueFilter.setComparator(this.filter.comparator);
        issueFilter.setDirection(this.filter.direction);
        user.store();
        return this.browse();
    }

    public String useFilter() {
        User user = User.currentUser();
        IssueFilter issueFilter = user.getIssueFilter(this.filter.key);
        if (issueFilter == null) {
            return this.browse();
        }
        this.filter.useFilter(issueFilter);
        this.paging.setPageStart(0);
        return this.browse();
    }

    public String browse() {
        if (User.currentUser().getIssueFilter(this.filter.key) == null) {
            this.filter.key = "";
            this.filter.name = "";
        }
        return "issue/browseIssues";
    }

    public IssueBrowser getBrowser() {
        IssueBrowserConfiguration browserConfiguration = User.currentUser().getIssueBrowserConfiguration();
        return new IssueBrowser(this.paging.getIssues(), browserConfiguration.getFields());
    }

    public HeaderSorting getHeaderSorting(IssueBrowser.BrowserHeader header) {
        return new HeaderSorting(header.getIssueField(), this.filter.comparator, this.filter.direction);
    }

    public Download exportToExcel() {
        IssueBrowserConfiguration browserConfiguration = User.currentUser().getIssueBrowserConfiguration();
        return new IssuesExcelDownload(this.filter.getIssues(), browserConfiguration.getFields());
    }
}

